/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.network.machines;

import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.ConfigurableScreenHandler;
import aztech.modern_industrialization.network.BasePacket;
import java.util.Objects;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public record UpdateItemSlotPacket(int syncId, int stackId, ConfigurableItemStack newStack) implements BasePacket
{
    public UpdateItemSlotPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readVarInt(), new ConfigurableItemStack(buf.readNbt()));
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.syncId);
        buf.writeVarInt(this.stackId);
        buf.writeNbt((Tag)this.newStack.toNbt());
    }

    @Override
    public void handle(BasePacket.Context ctx) {
        ctx.assertOnClient();
        AbstractContainerMenu sh = ctx.getPlayer().containerMenu;
        if (sh.containerId == this.syncId) {
            ConfigurableScreenHandler csh = (ConfigurableScreenHandler)sh;
            ConfigurableItemStack oldStack = csh.inventory.getItemStacks().get(this.stackId);
            csh.inventory.getItemStacks().set(this.stackId, this.newStack);
            for (int i = 0; i < csh.slots.size(); ++i) {
                ConfigurableItemStack.ConfigurableItemSlot is;
                Slot slot = (Slot)csh.slots.get(i);
                if (!(slot instanceof ConfigurableItemStack.ConfigurableItemSlot) || (is = (ConfigurableItemStack.ConfigurableItemSlot)slot).getConfStack() != oldStack) continue;
                ConfigurableItemStack configurableItemStack = this.newStack;
                Objects.requireNonNull(configurableItemStack);
                csh.updateSlot(i, configurableItemStack.new ConfigurableItemStack.ConfigurableItemSlot(is));
                return;
            }
            throw new RuntimeException("Could not find slot to replace!");
        }
    }
}

