/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.FluidNuclearComponent;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import java.util.Optional;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public interface INuclearTileData {
    public double getTemperature();

    public double getHeatTransferCoeff();

    public double getMeanNeutronAbsorption(NeutronType var1);

    public double getMeanNeutronFlux(NeutronType var1);

    public double getMeanNeutronGeneration();

    public double getMeanEuGeneration();

    public TransferVariant getVariant();

    public long getVariantAmount();

    public boolean isFluid();

    @Nullable
    default public INuclearComponent<?> getComponent() {
        FluidVariant resource;
        TransferVariant variant = this.getVariant();
        if (variant instanceof ItemVariant) {
            Item item;
            ItemVariant resource2 = (ItemVariant)variant;
            if (!variant.isBlank() && this.getVariantAmount() > 0L && (item = resource2.getItem()) instanceof INuclearComponent) {
                INuclearComponent comp = (INuclearComponent)item;
                return comp;
            }
        } else if (variant instanceof FluidVariant && !(resource = (FluidVariant)variant).isBlank() && this.getVariantAmount() > 0L) {
            return FluidNuclearComponent.get(resource.getFluid());
        }
        return null;
    }

    public static void write(Optional<INuclearTileData> maybeData, FriendlyByteBuf buf) {
        if (maybeData.isPresent()) {
            INuclearTileData tile = maybeData.get();
            buf.writeBoolean(true);
            buf.writeDouble(tile.getTemperature());
            buf.writeDouble(tile.getMeanNeutronAbsorption(NeutronType.FAST));
            buf.writeDouble(tile.getMeanNeutronAbsorption(NeutronType.THERMAL));
            buf.writeDouble(tile.getMeanNeutronFlux(NeutronType.FAST));
            buf.writeDouble(tile.getMeanNeutronFlux(NeutronType.THERMAL));
            buf.writeDouble(tile.getMeanNeutronGeneration());
            buf.writeDouble(tile.getHeatTransferCoeff());
            buf.writeDouble(tile.getMeanEuGeneration());
            buf.writeBoolean(!tile.isFluid());
            buf.writeNbt((Tag)tile.getVariant().toNbt());
            buf.writeLong(tile.getVariantAmount());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static Optional<INuclearTileData> read(FriendlyByteBuf buf) {
        boolean isPresent = buf.readBoolean();
        if (isPresent) {
            final double temperature = buf.readDouble();
            final double meanFastNeutronAbsorption = buf.readDouble();
            final double meanThermalNeutronAbsorption = buf.readDouble();
            final double meanFastNeutronFlux = buf.readDouble();
            final double meanThermalNeutronFlux = buf.readDouble();
            final double meanNeutronGeneration = buf.readDouble();
            final double heatTransferCoeff = buf.readDouble();
            final double euGeneration = buf.readDouble();
            final boolean isItem = buf.readBoolean();
            final TransferVariant<Item> variant = isItem ? ItemVariant.fromNbt(buf.readNbt()) : FluidVariant.fromNbt(buf.readNbt());
            final long amount = buf.readLong();
            return Optional.of(new INuclearTileData(){

                @Override
                public double getTemperature() {
                    return temperature;
                }

                @Override
                public double getHeatTransferCoeff() {
                    return heatTransferCoeff;
                }

                @Override
                public double getMeanNeutronAbsorption(NeutronType type) {
                    if (type == NeutronType.FAST) {
                        return meanFastNeutronAbsorption;
                    }
                    if (type == NeutronType.THERMAL) {
                        return meanThermalNeutronAbsorption;
                    }
                    return meanThermalNeutronAbsorption + meanFastNeutronAbsorption;
                }

                @Override
                public double getMeanNeutronFlux(NeutronType type) {
                    if (type == NeutronType.FAST) {
                        return meanFastNeutronFlux;
                    }
                    if (type == NeutronType.THERMAL) {
                        return meanThermalNeutronFlux;
                    }
                    return meanFastNeutronFlux + meanThermalNeutronFlux;
                }

                @Override
                public double getMeanNeutronGeneration() {
                    return meanNeutronGeneration;
                }

                @Override
                public double getMeanEuGeneration() {
                    return euGeneration;
                }

                @Override
                public TransferVariant getVariant() {
                    return variant;
                }

                @Override
                public long getVariantAmount() {
                    return amount;
                }

                @Override
                public boolean isFluid() {
                    return !isItem;
                }
            });
        }
        return Optional.empty();
    }

    public static boolean areEquals(Optional<INuclearTileData> a, Optional<INuclearTileData> b) {
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        if (a.isPresent()) {
            INuclearTileData A = a.get();
            INuclearTileData B = b.get();
            for (NeutronType type : NeutronType.TYPES) {
                if (A.getMeanNeutronAbsorption(type) != B.getMeanNeutronAbsorption(type)) {
                    return false;
                }
                if (A.getMeanNeutronFlux(type) == B.getMeanNeutronFlux(type)) continue;
                return false;
            }
            return A.getTemperature() == B.getTemperature() && A.getHeatTransferCoeff() == B.getTemperature() && A.getVariantAmount() == B.getVariantAmount() && A.getMeanNeutronGeneration() == B.getMeanNeutronGeneration() && A.getVariant().equals(B.getVariant()) && A.getMeanEuGeneration() == B.getMeanEuGeneration();
        }
        return true;
    }
}

