/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.model.DelegatingModelBuilder;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class MIPipes {
    public static final MIPipes INSTANCE = new MIPipes();
    public static final Supplier<PipeBlock> BLOCK_PIPE = MIBlock.BLOCKS.register("pipe", () -> new PipeBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).destroyTime(2.0f)));
    public static Supplier<BlockEntityType<PipeBlockEntity>> BLOCK_ENTITY_TYPE_PIPE;
    public static volatile boolean transparentCamouflage;
    private final Map<PipeNetworkType, Supplier<PipeItem>> pipeItems = new HashMap<PipeNetworkType, Supplier<PipeItem>>();
    public static final Map<PipeNetworkType, CableTier> ELECTRICITY_PIPE_TIER;
    public static final Supplier<MenuType<ItemPipeScreenHandler>> SCREEN_HANDLER_TYPE_ITEM_PIPE;
    public static final Supplier<MenuType<FluidPipeScreenHandler>> SCREEN_HANDLER_TYPE_FLUID_PIPE;
    public static final BiConsumer<Item, ItemModelProvider> ITEM_MODEL_GENERATOR;

    public void setup() {
        BLOCK_ENTITY_TYPE_PIPE = MIRegistries.BLOCK_ENTITIES.register("pipe", () -> BlockEntityType.Builder.of(PipeBlockEntity::new, (Block[])new Block[]{BLOCK_PIPE.get()}).build(null));
        for (PipeColor color : PipeColor.values()) {
            this.registerFluidPipeType(color);
        }
        for (PipeColor color : PipeColor.values()) {
            this.registerItemPipeType(color);
        }
        if (MIConfig.loadAe2Compat()) {
            try {
                Class.forName("aztech.modern_industrialization.compat.ae2.MIAEAddon").getMethod("onInitializePipes", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerFluidPipeType(PipeColor color) {
        String pipeId = color.prefix + "fluid_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), (id, data) -> new FluidNetwork((int)id, (PipeNetworkData)data, 1000), FluidNetworkNode::new, color.color, true);
        ItemDefinition<PipeItem> itemDef = MIItem.item(color.englishNamePrefix + "Fluid Pipe", pipeId, prop -> new PipeItem((Item.Properties)prop, type, new FluidNetworkData(FluidVariant.blank())), ITEM_MODEL_GENERATOR, SortOrder.PIPES);
        this.register(type, itemDef::asItem);
        TagsToGenerate.generateTag(MITags.FLUID_PIPES, itemDef, "Fluid Pipes");
    }

    private void registerItemPipeType(PipeColor color) {
        String pipeId = color.prefix + "item_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), ItemNetwork::new, ItemNetworkNode::new, color.color, true);
        ItemDefinition<PipeItem> itemDef = MIItem.item(color.englishNamePrefix + "Item Pipe", pipeId, prop -> new PipeItem((Item.Properties)prop, type, new ItemNetworkData()), ITEM_MODEL_GENERATOR, SortOrder.PIPES);
        this.register(type, itemDef::asItem);
        TagsToGenerate.generateTag(MITags.ITEM_PIPES, itemDef, "Item Pipes");
    }

    public void registerCableType(String englishName, String name, int color, CableTier tier) {
        String cableId = name + "_cable";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(cableId), (id, data) -> new ElectricityNetwork((int)id, (PipeNetworkData)data, tier), ElectricityNetworkNode::new, color, false);
        ItemDefinition<PipeItem> itemDef = MIItem.item(englishName, cableId, prop -> new PipeItem((Item.Properties)prop, type, new ElectricityNetworkData()), ITEM_MODEL_GENERATOR, SortOrder.CABLES.and(tier));
        this.register(type, itemDef::asItem);
        ELECTRICITY_PIPE_TIER.put(type, tier);
    }

    public void register(PipeNetworkType type, Supplier<PipeItem> item) {
        if (this.pipeItems.containsKey(type)) {
            throw new IllegalStateException("Type " + type + " already registered");
        }
        this.pipeItems.put(type, item);
    }

    public PipeItem getPipeItem(PipeNetworkType type) {
        return this.pipeItems.get(type).get();
    }

    static {
        transparentCamouflage = false;
        ELECTRICITY_PIPE_TIER = new HashMap<PipeNetworkType, CableTier>();
        SCREEN_HANDLER_TYPE_ITEM_PIPE = MIRegistries.MENUS.register("item_pipe", () -> IMenuTypeExtension.create(ItemPipeScreenHandler::new));
        SCREEN_HANDLER_TYPE_FLUID_PIPE = MIRegistries.MENUS.register("fluid_pipe", () -> IMenuTypeExtension.create(FluidPipeScreenHandler::new));
        ITEM_MODEL_GENERATOR = (item, modelGenerator) -> ((DelegatingModelBuilder)((ItemModelBuilder)modelGenerator.getBuilder(BuiltInRegistries.ITEM.getKey(item).getPath())).customLoader(DelegatingModelBuilder::new)).delegate((ModelFile)modelGenerator.getExistingFile(MI.id("block/pipe"))).end();
    }
}

