/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.api;

import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public abstract class PipeNetwork {
    protected int id;
    public PipeNetworkManager manager;
    public PipeNetworkData data;
    private final Map<BlockPos, PipeNetworkNode> nodes = new HashMap<BlockPos, PipeNetworkNode>();
    private final Map<Long, Map<BlockPos, PipeNetworkNode>> nodesByChunk = new HashMap<Long, Map<BlockPos, PipeNetworkNode>>();
    private final List<PosNode> tickingNodesCache = new ArrayList<PosNode>();
    boolean tickingCacheValid = false;

    public PipeNetwork(int id, PipeNetworkData data) {
        this.id = id;
        this.data = data;
    }

    public void fromTag(CompoundTag tag) {
        this.id = tag.getInt("id");
        this.data.fromTag(tag.getCompound("data"));
    }

    public CompoundTag toTag(CompoundTag tag) {
        tag.putInt("id", this.id);
        tag.put("data", (Tag)this.data.toTag(new CompoundTag()));
        return tag;
    }

    public void tick(ServerLevel world) {
    }

    public PipeNetworkData merge(PipeNetwork other) {
        return null;
    }

    public void onRemove() {
    }

    @Nullable
    public PipeNetworkNode getNode(BlockPos pos) {
        return this.nodes.get(pos);
    }

    public void setNode(BlockPos pos, @Nullable PipeNetworkNode node) {
        this.nodes.put(pos.immutable(), node);
        this.nodesByChunk.computeIfAbsent(ChunkPos.asLong((BlockPos)pos), p -> new HashMap()).put(pos.immutable(), node);
    }

    public void removeNode(BlockPos pos) {
        this.nodes.remove(pos);
        long chunk = ChunkPos.asLong((BlockPos)pos);
        Map<BlockPos, PipeNetworkNode> map = this.nodesByChunk.get(chunk);
        map.remove(pos);
        if (map.size() == 0) {
            this.nodesByChunk.remove(chunk);
        }
    }

    public Map<BlockPos, PipeNetworkNode> getRawNodeMap() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public Collection<PosNode> iterateTickingNodes() {
        if (!this.tickingCacheValid) {
            this.tickingNodesCache.clear();
            for (Map.Entry<Long, Map<BlockPos, PipeNetworkNode>> chunkEntry : this.nodesByChunk.entrySet()) {
                if (!this.manager.tickingChunks.contains((Object)chunkEntry.getKey())) continue;
                for (Map.Entry<BlockPos, PipeNetworkNode> entry : chunkEntry.getValue().entrySet()) {
                    PipeNetworkNode node = entry.getValue();
                    if (node == null) continue;
                    this.tickingNodesCache.add(new PosNode(entry.getKey(), node));
                }
            }
            this.tickingCacheValid = true;
        }
        return this.tickingNodesCache;
    }

    public static class PosNode {
        private final BlockPos pos;
        private final PipeNetworkNode node;

        public PosNode(BlockPos pos, PipeNetworkNode node) {
            this.pos = pos;
            this.node = node;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public PipeNetworkNode getNode() {
            return this.node;
        }
    }
}

