/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.electricity;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;

public class ElectricityNetworkNode
extends PipeNetworkNode {
    private List<Direction> connections = new ArrayList<Direction>();
    private final List<BlockCapabilityCache<MIEnergyStorage, @NotNull Direction>> caches = new ArrayList<BlockCapabilityCache<MIEnergyStorage, Direction>>();
    long eu = 0L;

    public void appendAttributes(ServerLevel world, BlockPos pos, CableTier cableTier, List<MIEnergyStorage> storages) {
        if (this.caches.size() != this.connections.size()) {
            this.caches.clear();
            for (Direction direction : this.connections) {
                this.caches.add((BlockCapabilityCache<MIEnergyStorage, Direction>)BlockCapabilityCache.create(EnergyApi.SIDED, (ServerLevel)world, (BlockPos)pos.relative(direction), (Object)direction.getOpposite()));
            }
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            MIEnergyStorage storage = (MIEnergyStorage)this.caches.get(i).getCapability();
            if (storage == null || !storage.canConnect(cableTier)) continue;
            storages.add(storage);
        }
    }

    @Override
    public void buildInitialConnections(Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canConnect(world, pos, direction)) continue;
            this.connections.add(direction);
        }
    }

    @Override
    public void updateConnections(Level world, BlockPos pos) {
        int i = 0;
        while (i < this.connections.size()) {
            if (this.canConnect(world, pos, this.connections.get(i))) {
                ++i;
                continue;
            }
            this.connections.remove(i);
            this.caches.clear();
        }
    }

    @Override
    public PipeEndpointType[] getConnections(BlockPos pos) {
        PipeEndpointType[] connections = new PipeEndpointType[6];
        for (Direction direction : this.network.manager.getNodeLinks(pos)) {
            connections[direction.get3DDataValue()] = PipeEndpointType.PIPE;
        }
        for (Direction connection : this.connections) {
            connections[connection.get3DDataValue()] = PipeEndpointType.BLOCK;
        }
        return connections;
    }

    @Override
    public void removeConnection(Level world, BlockPos pos, Direction direction) {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get(i) != direction) continue;
            this.connections.remove(i);
            this.caches.clear();
            return;
        }
    }

    @Override
    public void addConnection(PipeBlockEntity pipe, Player player, Level world, BlockPos pos, Direction direction) {
        for (Direction connection : this.connections) {
            if (connection != direction) continue;
            return;
        }
        if (this.canConnect(world, pos, direction)) {
            this.connections.add(direction);
            this.caches.clear();
        }
    }

    @Override
    public CompoundTag toTag(CompoundTag tag) {
        tag.putByte("connections", NbtHelper.encodeDirections(this.connections));
        tag.putLong("eu", this.eu);
        return tag;
    }

    @Override
    public void fromTag(CompoundTag tag) {
        this.connections = new ArrayList<Direction>(Arrays.asList(NbtHelper.decodeDirections(tag.getByte("connections"))));
        this.caches.clear();
        this.eu = tag.getLong("eu");
    }

    private boolean canConnect(Level world, BlockPos pos, Direction direction) {
        MIEnergyStorage storage = (MIEnergyStorage)world.getCapability(EnergyApi.SIDED, pos.relative(direction), (Object)direction.getOpposite());
        return storage != null && (storage.canReceive() || storage.canExtract());
    }

    private long getMaxTransfer() {
        return ((ElectricityNetwork)this.network).tier.getMaxTransfer();
    }

    public InGameInfo collectNetworkInfo() {
        long stored = 0L;
        long capacity = 0L;
        for (PipeNetwork.PosNode posNode : this.network.iterateTickingNodes()) {
            ElectricityNetworkNode node = (ElectricityNetworkNode)posNode.getNode();
            stored += node.eu;
            capacity += this.getMaxTransfer();
        }
        return new InGameInfo(stored, capacity, ((ElectricityNetwork)this.network).stats.getValue(), this.getMaxTransfer());
    }

    public record InGameInfo(long stored, long capacity, long transfer, long maxTransfer) {
    }
}

