/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.pipes.PipeStatsCollector;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidTarget;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidNetwork
extends PipeNetwork {
    final int nodeCapacity;
    final PipeStatsCollector stats = new PipeStatsCollector();

    public FluidNetwork(int id, PipeNetworkData data, int nodeCapacity) {
        super(id, data == null ? new FluidNetworkData(FluidVariant.blank()) : data);
        this.nodeCapacity = nodeCapacity;
    }

    @Override
    public void tick(ServerLevel world) {
        ArrayList<FluidTarget> targets = new ArrayList<FluidTarget>();
        long networkAmount = 0L;
        int loadedNodeCount = 0;
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            FluidNetworkNode fluidNode = (FluidNetworkNode)entry.getNode();
            fluidNode.gatherTargetsAndPickFluid(world, entry.getPos(), targets);
            networkAmount += fluidNode.amount;
            ++loadedNodeCount;
        }
        long networkCapacity = (long)loadedNodeCount * (long)this.nodeCapacity;
        FluidVariant fluid = ((FluidNetworkData)this.data).fluid;
        long extracted = 0L;
        long inserted = 0L;
        if (!fluid.isBlank()) {
            extracted = FluidNetwork.transferByPriority(TransferOperation.EXTRACT, targets, fluid, networkCapacity - networkAmount);
            inserted = FluidNetwork.transferByPriority(TransferOperation.INSERT, targets, fluid, networkAmount += extracted);
            networkAmount -= inserted;
            for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
                FluidNetworkNode fluidNode = (FluidNetworkNode)entry.getNode();
                fluidNode.amount = networkAmount / (long)loadedNodeCount;
                networkAmount -= fluidNode.amount;
                --loadedNodeCount;
            }
        }
        this.stats.addValue(Math.max(extracted, inserted));
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ((FluidNetworkNode)entry.getNode()).afterTick(world, entry.getPos());
        }
    }

    private static long transferByPriority(TransferOperation operation, List<FluidTarget> targets, FluidVariant fluid, long maxAmount) {
        targets.sort(Comparator.comparingInt(target -> -target.priority));
        long transferredAmount = 0L;
        int bucketStart = 0;
        for (int i = 0; i < targets.size(); ++i) {
            if (i != targets.size() - 1 && targets.get((int)bucketStart).priority == targets.get((int)(i + 1)).priority) continue;
            transferredAmount += FluidNetwork.transferForBucket(operation, targets.subList(bucketStart, i + 1), fluid, maxAmount - transferredAmount);
            bucketStart = i + 1;
        }
        return transferredAmount;
    }

    private static long transferForBucket(TransferOperation operation, List<FluidTarget> bucket, FluidVariant fluid, long maxAmount) {
        Collections.shuffle(bucket);
        for (FluidTarget target2 : bucket) {
            target2.simulationResult = operation.transfer(target2.storage, fluid, maxAmount, true);
        }
        bucket.sort(Comparator.comparingLong(target -> target.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < bucket.size(); ++i) {
            FluidTarget target3 = bucket.get(i);
            int remainingTargets = bucket.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            long targetMaxAmount = remainingAmount / (long)remainingTargets;
            transferredAmount += operation.transfer(target3.storage, fluid, targetMaxAmount, false);
        }
        return transferredAmount;
    }

    @Override
    public PipeNetworkData merge(PipeNetwork other) {
        FluidNetworkData thisData = (FluidNetworkData)this.data;
        FluidNetworkData otherData = (FluidNetworkData)other.data;
        for (int i = 0; i < 2; ++i) {
            boolean onlyFluid;
            boolean bl = onlyFluid = i == 0;
            if (this.isEmpty(onlyFluid)) {
                return otherData.clone();
            }
            if (!((FluidNetwork)other).isEmpty(onlyFluid)) continue;
            return thisData.clone();
        }
        return null;
    }

    private boolean isEmpty(boolean onlyFluid) {
        if (((FluidNetworkData)this.data).fluid.isBlank()) {
            return true;
        }
        if (onlyFluid) {
            return false;
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node != null && ((FluidNetworkNode)node).amount == 0L) continue;
            return false;
        }
        return true;
    }

    protected void setFluid(FluidVariant fluid) {
        if (((FluidNetworkData)this.data).fluid.isBlank()) {
            ((FluidNetworkData)this.data).fluid = fluid;
        }
    }

    protected void clearFluid() {
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            if (node != null) continue;
            return;
        }
        for (PipeNetworkNode node : this.getRawNodeMap().values()) {
            ((FluidNetworkNode)node).amount = 0L;
        }
        ((FluidNetworkData)this.data).fluid = FluidVariant.blank();
    }

    @FunctionalInterface
    private static interface TransferOperation {
        public static final TransferOperation INSERT = (handler, fluid, maxAmount, simulate) -> handler.fill(fluid.toStack(Ints.saturatedCast((long)maxAmount)), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        public static final TransferOperation EXTRACT = (handler, fluid, maxAmount, simulate) -> handler.drain(fluid.toStack(Ints.saturatedCast((long)maxAmount)), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount();

        public long transfer(IFluidHandler var1, FluidVariant var2, long var3, boolean var5);
    }
}

