/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.fluid;

import aztech.modern_industrialization.network.pipes.SetConnectionTypePacket;
import aztech.modern_industrialization.network.pipes.SetNetworkFluidPacket;
import aztech.modern_industrialization.network.pipes.SetPriorityPacket;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.fluid.FluidPipeInterface;
import aztech.modern_industrialization.pipes.gui.PipeScreenHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FluidPipeScreenHandler
extends PipeScreenHandler {
    public static final int HEIGHT = 153;
    public final FluidPipeInterface iface;
    private final Inventory playerInventory;
    private FluidVariant trackedNetworkFluid;
    private int trackedPriority;
    private int trackedType;

    public FluidPipeScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(syncId, playerInventory, FluidPipeInterface.ofBuf(buf));
    }

    public FluidPipeScreenHandler(int syncId, Inventory playerInventory, FluidPipeInterface iface) {
        super(MIPipes.SCREEN_HANDLER_TYPE_FLUID_PIPE.get(), syncId);
        this.iface = iface;
        this.playerInventory = playerInventory;
        this.trackedNetworkFluid = iface.getNetworkFluid();
        this.trackedPriority = iface.getPriority(0);
        this.trackedType = iface.getConnectionType();
        this.addPlayerInventorySlots(playerInventory, 153);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.playerInventory.player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)this.playerInventory.player;
            if (!this.trackedNetworkFluid.equals(this.iface.getNetworkFluid())) {
                this.trackedNetworkFluid = this.iface.getNetworkFluid();
                new SetNetworkFluidPacket(this.containerId, this.trackedNetworkFluid).sendToClient(serverPlayer);
            }
            if (this.trackedType != this.iface.getConnectionType()) {
                this.trackedType = this.iface.getConnectionType();
                new SetConnectionTypePacket(this.containerId, this.trackedType).sendToClient(serverPlayer);
            }
            if (this.trackedPriority != this.iface.getPriority(0)) {
                this.trackedPriority = this.iface.getPriority(0);
                new SetPriorityPacket(this.containerId, 0, this.trackedPriority).sendToClient(serverPlayer);
            }
        }
    }

    public boolean stillValid(Player player) {
        return this.iface.canUse(player);
    }

    @Override
    protected Object getInterface() {
        return this.iface;
    }
}

