/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.gui;

import aztech.modern_industrialization.client.DynamicTooltip;
import aztech.modern_industrialization.pipes.gui.PipeGuiHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

class PriorityButton
extends Button {
    private final int u;

    public PriorityButton(int x, int y, int width, int u, String message, Button.OnPress onPress, Supplier<List<Component>> tooltipSupplier) {
        super(x, y, width, 12, (Component)Component.literal((String)message), onPress, Button.DEFAULT_NARRATION);
        this.u = u;
        this.setTooltip(new DynamicTooltip(tooltipSupplier));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.getInstance();
        Font font = minecraftClient.font;
        int v = this.isHoveredOrFocused() ? 40 + this.height : 40;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blit(PipeGuiHelper.BUTTON_TEXTURE, this.getX(), this.getY(), this.u, v, this.width, this.height);
        int j = this.active ? 0xFFFFFF : 0xA0A0A0;
        guiGraphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

