/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.blocks.FastBlockEntity;
import aztech.modern_industrialization.blocks.WrenchableBlockEntity;
import aztech.modern_industrialization.items.ConfigCardItem;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.IPipeMenuProvider;
import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkNode;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.gui.IPipeScreenHandlerHelper;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.pipes.impl.PipeShapeBuilder;
import aztech.modern_industrialization.pipes.impl.PipeVoxelShape;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.TransferHelper;
import aztech.modern_industrialization.util.WorldHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.jetbrains.annotations.Nullable;

public class PipeBlockEntity
extends FastBlockEntity
implements IPipeScreenHandlerHelper,
WrenchableBlockEntity {
    private static final int MAX_PIPES = 3;
    private static final VoxelShape[][][] SHAPE_CACHE = new VoxelShape[3][6][5];
    private static final VoxelShape[] ME_WIRE_CONNECTOR_SHAPES;
    static final VoxelShape DEFAULT_SHAPE;
    VoxelShape currentCollisionShape = Shapes.empty();
    private final SortedSet<PipeNetworkNode> pipes = new TreeSet<PipeNetworkNode>(Comparator.comparing(PipeNetworkNode::getType));
    SortedMap<PipeNetworkType, PipeEndpointType[]> connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
    SortedMap<PipeNetworkType, CompoundTag> customData = new TreeMap<PipeNetworkType, CompoundTag>();
    @Nullable
    BlockState camouflage = null;
    private final List<Tuple<PipeNetworkType, PipeNetworkNode>> unloadedPipes = new ArrayList<Tuple<PipeNetworkType, PipeNetworkNode>>();
    boolean stateReplaced = false;

    public void loadPipes() {
        if (this.level.isClientSide || this.unloadedPipes.size() == 0) {
            return;
        }
        for (Tuple<PipeNetworkType, PipeNetworkNode> unloaded : this.unloadedPipes) {
            PipeNetworks.get((ServerLevel)this.level).getManager((PipeNetworkType)unloaded.getA()).nodeLoaded((PipeNetworkNode)unloaded.getB(), this.worldPosition);
            this.pipes.add((PipeNetworkNode)unloaded.getB());
        }
        this.unloadedPipes.clear();
        this.updateConnections();
    }

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(MIPipes.BLOCK_ENTITY_TYPE_PIPE.get(), pos, state);
    }

    void updateConnections() {
        this.loadPipes();
        for (PipeNetworkNode pipe : this.pipes) {
            pipe.updateConnections(this.level, this.worldPosition);
        }
        this.onConnectionsChanged();
    }

    public SortedSet<PipeNetworkNode> getNodes() {
        this.loadPipes();
        return Collections.unmodifiableSortedSet(this.pipes);
    }

    boolean canAddPipe(PipeNetworkType type) {
        this.loadPipes();
        if (this.level.isClientSide) {
            return this.connections.size() < 3 && !this.connections.containsKey(type);
        }
        if (this.pipes.size() == 3) {
            return false;
        }
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return false;
        }
        return true;
    }

    void addPipe(PipeNetworkType type, PipeNetworkData data) {
        if (!this.canAddPipe(type)) {
            return;
        }
        PipeNetworkNode node = type.getNodeCtor().get();
        PipeNetworkManager manager = PipeNetworks.get((ServerLevel)this.level).getManager(type);
        manager.addNode(node, this.worldPosition, data);
        for (Direction direction : Direction.values()) {
            manager.addLink(this.worldPosition, direction, false);
        }
        this.pipes.add(node);
        node.buildInitialConnections(this.level, this.worldPosition);
        this.updateConnections();
    }

    public void removePipeAndDropContainedItems(PipeNetworkType type) {
        this.loadPipes();
        PipeNetworkNode removedPipe = null;
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            removedPipe = pipe;
            break;
        }
        if (removedPipe == null) {
            throw new IllegalArgumentException("Can't remove type " + type.getIdentifier() + " from BlockEntity at pos " + this.worldPosition);
        }
        this.pipes.remove(removedPipe);
        removedPipe.getManager().removeNode(this.worldPosition);
        this.onConnectionsChanged();
        ArrayList<ItemStack> droppedStacks = new ArrayList<ItemStack>();
        removedPipe.appendDroppedStacks(droppedStacks);
        for (ItemStack droppedStack : droppedStacks) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), droppedStack));
        }
    }

    public void removeConnection(PipeNetworkType type, Direction direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.removeConnection(this.level, this.worldPosition, direction);
            pipe.getManager().removeLink(this.worldPosition, direction);
            this.onConnectionsChanged();
            return;
        }
    }

    public void addConnection(Player player, PipeNetworkType type, Direction direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            pipe.addConnection(this, player, this.level, this.worldPosition, direction);
            pipe.getManager().addLink(this.worldPosition, direction, true);
            pipe.updateConnections(this.level, this.worldPosition);
            this.onConnectionsChanged();
            return;
        }
    }

    public boolean hasCamouflage() {
        return this.camouflage != null;
    }

    public ItemStack getCamouflageStack() {
        Objects.requireNonNull(this.camouflage, "Can't get camouflage stack when there is no camouflage");
        return new ItemStack((ItemLike)this.camouflage.getBlock());
    }

    private void setCamouflage(Player player, @Nullable BlockState newCamouflage) {
        SoundEvent sound;
        SoundType group;
        boolean hadCamouflage = this.hasCamouflage();
        if (this.camouflage != null) {
            if (newCamouflage == null || newCamouflage.getBlock() != this.camouflage.getBlock()) {
                BlockPos pos = this.worldPosition;
                Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.getCamouflageStack());
            }
            if (newCamouflage == null) {
                group = this.camouflage.getSoundType();
                sound = group.getBreakSound();
                this.level.playSound(player, this.worldPosition, sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
            }
            this.camouflage = null;
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.sync();
                this.rebuildCollisionShape();
            }
        }
        this.camouflage = newCamouflage;
        if (newCamouflage != null) {
            group = newCamouflage.getSoundType();
            sound = group.getPlaceSound();
            this.level.playSound(player, this.worldPosition, sound, SoundSource.BLOCKS, (group.getVolume() + 1.0f) / 4.0f, group.getPitch() * 0.8f);
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.sync();
                this.rebuildCollisionShape();
            }
        }
        if (hadCamouflage != this.hasCamouflage()) {
            BlockState newState = (BlockState)this.getBlockState().setValue((Property)PipeBlock.CAMOUFLAGED, (Comparable)Boolean.valueOf(this.hasCamouflage()));
            if (this.hasCamouflage()) {
                newState = (BlockState)newState.setValue((Property)PipeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            this.level.setBlockAndUpdate(this.worldPosition, newState);
        }
    }

    public boolean tryRemoveCamouflage(Player player, InteractionHand hand) {
        ItemStack handStack = player.getItemInHand(hand);
        if (this.camouflage == null || !handStack.is(MITags.WRENCHES)) {
            return false;
        }
        this.setCamouflage(player, null);
        return true;
    }

    public boolean tryApplyCamouflage(Player player, InteractionHand hand) {
        boolean itemChanged;
        ItemStack handStack = player.getItemInHand(hand);
        if (!MIItem.CONFIG_CARD.is(handStack)) {
            return false;
        }
        if (player.isShiftKeyDown()) {
            if (this.camouflage != null) {
                return ConfigCardItem.setCamouflage(player, hand, this.camouflage);
            }
            return false;
        }
        BlockState newCamouflage = ConfigCardItem.readCamouflage(handStack);
        if (newCamouflage.isAir()) {
            return false;
        }
        if (newCamouflage == this.camouflage) {
            return true;
        }
        boolean bl = itemChanged = this.camouflage == null || newCamouflage.getBlock() != this.camouflage.getBlock();
        if (!player.getAbilities().instabuild && itemChanged) {
            Item itemToUse = newCamouflage.getBlock().asItem();
            ItemStack extracted = TransferHelper.extractMatching((IItemHandler)new PlayerInvWrapper(player.getInventory()), s -> s.is(itemToUse), 1);
            if (extracted.isEmpty()) {
                player.displayClientMessage((Component)MITooltips.line(MIText.ConfigCardNoCamouflageInInventory).arg(newCamouflage, MITooltips.BLOCK_STATE_PARSER).build().withStyle(ChatFormatting.RED), true);
                return true;
            }
        }
        this.setCamouflage(player, newCamouflage);
        return true;
    }

    public boolean customUse(PipeVoxelShape shape, Player player, InteractionHand hand) {
        for (PipeNetworkNode node : this.pipes) {
            if (node.getType() != shape.type) continue;
            return node.customUse(this, player, hand, shape.direction);
        }
        return false;
    }

    public IPipeMenuProvider getGui(PipeNetworkType type, Direction direction) {
        for (PipeNetworkNode pipe : this.pipes) {
            if (pipe.getType() != type) continue;
            return pipe.getConnectionGui(direction, this);
        }
        return null;
    }

    public void setRemoved() {
        if (this.stateReplaced) {
            this.loadPipes();
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.getManager().removeNode(this.worldPosition);
            }
        } else {
            for (PipeNetworkNode pipe : this.pipes) {
                pipe.onUnload();
                pipe.getManager().nodeUnloaded(pipe, this.worldPosition);
            }
        }
        super.setRemoved();
    }

    public void saveAdditional(CompoundTag tag) {
        int i = 0;
        for (PipeNetworkNode pipeNetworkNode : this.pipes) {
            tag.putString("pipe_type_" + i, pipeNetworkNode.getType().getIdentifier().toString());
            tag.put("pipe_data_" + i, (Tag)pipeNetworkNode.toTag(new CompoundTag()));
            ++i;
        }
        for (Tuple tuple : this.unloadedPipes) {
            tag.putString("pipe_type_" + i, ((PipeNetworkType)tuple.getA()).getIdentifier().toString());
            tag.put("pipe_data_" + i, (Tag)((PipeNetworkNode)tuple.getB()).toTag(new CompoundTag()));
            ++i;
        }
        if (this.camouflage != null) {
            tag.put("camouflage", (Tag)NbtUtils.writeBlockState((BlockState)this.camouflage));
        }
    }

    public void load(CompoundTag tag) {
        BlockState blockState = this.camouflage = tag.contains("camouflage") ? NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("camouflage")) : null;
        if (!tag.contains("pipes")) {
            this.pipes.clear();
            int i = 0;
            while (tag.contains("pipe_type_" + i)) {
                ResourceLocation typeId = new ResourceLocation(tag.getString("pipe_type_" + i));
                PipeNetworkType type = PipeNetworkType.get(typeId);
                PipeNetworkNode node = type.getNodeCtor().get();
                node.fromTag(tag.getCompound("pipe_data_" + i));
                this.unloadedPipes.add((Tuple<PipeNetworkType, PipeNetworkNode>)new Tuple((Object)type, (Object)node));
                ++i;
            }
        } else {
            this.connections.clear();
            this.customData.clear();
            CompoundTag pipesTag = tag.getCompound("pipes");
            for (String key : pipesTag.getAllKeys()) {
                CompoundTag nodeTag = pipesTag.getCompound(key);
                PipeNetworkType type = PipeNetworkType.get(new ResourceLocation(key));
                this.connections.put(type, NbtHelper.decodeConnections(nodeTag.getByteArray("connections")));
                this.customData.put(type, nodeTag.getCompound("custom").copy());
            }
            this.rebuildCollisionShape();
            this.requestModelDataUpdate();
            WorldHelper.forceChunkRemesh(this.level, this.worldPosition);
        }
    }

    public void clearRemoved() {
        PipeNetworks.scheduleLoadPipe(this.level, this);
    }

    public void onConnectionsChanged() {
        SortedMap<PipeNetworkType, PipeEndpointType[]> oldRendererConnections = this.connections;
        this.connections = new TreeMap<PipeNetworkType, PipeEndpointType[]>();
        for (PipeNetworkNode pipe : this.pipes) {
            this.connections.put(pipe.getType(), pipe.getConnections(this.worldPosition));
        }
        if (!this.connections.equals(oldRendererConnections)) {
            this.rebuildCollisionShape();
            this.sync();
        }
        this.setChanged();
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.loadPipes();
        CompoundTag pipesTag = new CompoundTag();
        for (PipeNetworkNode pipe : this.pipes) {
            CompoundTag nodeTag = new CompoundTag();
            nodeTag.put("custom", (Tag)pipe.writeCustomData());
            nodeTag.putByteArray("connections", NbtHelper.encodeConnections(pipe.getConnections(this.worldPosition)));
            pipesTag.put(pipe.getType().getIdentifier().toString(), (Tag)nodeTag);
        }
        tag.put("pipes", (Tag)pipesTag);
        if (this.camouflage != null) {
            tag.put("camouflage", (Tag)NbtUtils.writeBlockState((BlockState)this.camouflage));
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ModelData getModelData() {
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        CompoundTag[] customData = new CompoundTag[this.connections.size()];
        int i = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> entry : this.connections.entrySet()) {
            types[i] = entry.getKey();
            renderedConnections[i] = Arrays.copyOf(entry.getValue(), 6);
            customData[i] = (CompoundTag)this.customData.get(entry.getKey());
            ++i;
        }
        return ModelData.builder().with(RenderAttachment.KEY, (Object)new RenderAttachment(this.camouflage, types, renderedConnections, customData)).build();
    }

    @Override
    public void callSync() {
        this.sync();
    }

    @Override
    public void callMarkDirty() {
        this.setChanged();
    }

    @Override
    public boolean isWithinUseDistance(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Override
    public boolean doesNodeStillExist(PipeNetworkNode node) {
        return this.pipes.contains(node);
    }

    @Override
    public boolean useWrench(Player player, InteractionHand hand, BlockHitResult hitResult) {
        return PipeBlock.useWrench(this, player, hand, hitResult);
    }

    public Collection<PipeVoxelShape> getPartShapes() {
        ArrayList<PipeVoxelShape> shapes = new ArrayList<PipeVoxelShape>();
        PipeEndpointType[][] renderedConnections = new PipeEndpointType[this.connections.size()][];
        PipeNetworkType[] types = new PipeNetworkType[this.connections.size()];
        int slot = 0;
        for (Map.Entry<PipeNetworkType, PipeEndpointType[]> connections : this.connections.entrySet()) {
            renderedConnections[slot] = connections.getValue();
            types[slot] = connections.getKey();
            ++slot;
        }
        for (slot = 0; slot < renderedConnections.length; ++slot) {
            shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][Direction.NORTH.get3DDataValue()][0], types[slot], null, false));
            for (Direction direction : Direction.values()) {
                int connectionType = PipePartBuilder.getRenderType(slot, direction, renderedConnections);
                if (connectionType == 0) continue;
                PipeEndpointType connType = renderedConnections[slot][direction.get3DDataValue()];
                boolean opensGui = connType != null && connType != PipeEndpointType.PIPE && types[slot].opensGui();
                shapes.add(new PipeVoxelShape(SHAPE_CACHE[slot][direction.get3DDataValue()][connectionType], types[slot], direction, opensGui));
            }
        }
        return shapes;
    }

    private void rebuildCollisionShape() {
        if (this.camouflage != null) {
            this.currentCollisionShape = Shapes.block();
        } else {
            this.currentCollisionShape = this.getPartShapes().stream().map(vs -> vs.shape).reduce(Shapes.empty(), Shapes::or);
            for (Direction direction : Direction.values()) {
                boolean renderConnector = false;
                for (Map.Entry<PipeNetworkType, PipeEndpointType[]> entry : this.connections.entrySet()) {
                    PipeEndpointType conn = entry.getValue()[direction.get3DDataValue()];
                    if (conn != PipeEndpointType.BLOCK || !entry.getKey().getIdentifier().getPath().endsWith("me_wire")) continue;
                    renderConnector = true;
                }
                if (!renderConnector) continue;
                this.currentCollisionShape = Shapes.or((VoxelShape)this.currentCollisionShape, (VoxelShape)ME_WIRE_CONNECTOR_SHAPES[direction.get3DDataValue()]);
            }
            this.currentCollisionShape = this.currentCollisionShape.optimize();
        }
    }

    public static VoxelShape[] buildSideShapes(double connectorSide, double connectorDepth) {
        double connectorSideStart = (1.0 - connectorSide) / 2.0;
        double connectorSideEnd = connectorSideStart + connectorSide;
        return new VoxelShape[]{Shapes.box((double)connectorSideStart, (double)0.0, (double)connectorSideStart, (double)connectorSideEnd, (double)connectorDepth, (double)connectorSideEnd), Shapes.box((double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideEnd, (double)1.0, (double)connectorSideEnd), Shapes.box((double)connectorSideStart, (double)connectorSideStart, (double)0.0, (double)connectorSideEnd, (double)connectorSideEnd, (double)connectorDepth), Shapes.box((double)connectorSideStart, (double)connectorSideStart, (double)(1.0 - connectorDepth), (double)connectorSideEnd, (double)connectorSideEnd, (double)1.0), Shapes.box((double)0.0, (double)connectorSideStart, (double)connectorSideStart, (double)connectorDepth, (double)connectorSideEnd, (double)connectorSideEnd), Shapes.box((double)(1.0 - connectorDepth), (double)connectorSideStart, (double)connectorSideStart, (double)1.0, (double)connectorSideEnd, (double)connectorSideEnd)};
    }

    private static void validateShapes() {
        int intersectingConfigurations = 0;
        int nonIntersectingConfigurations = 0;
        PipeEndpointType[][] endpoints = new PipeEndpointType[3][6];
        int maxMask = 262144;
        for (int mask = 0; mask < maxMask; ++mask) {
            VoxelShape[] shapes = new VoxelShape[]{Shapes.empty(), Shapes.empty(), Shapes.empty()};
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 6; ++j) {
                    boolean hasConnection = (mask & 1 << i * 6 + j) != 0;
                    endpoints[i][j] = hasConnection ? PipeEndpointType.PIPE : null;
                    int renderType = PipeShapeBuilder.getRenderType(i, Direction.from3DDataValue((int)j), endpoints);
                    if (renderType == 0) continue;
                    shapes[i] = Shapes.or((VoxelShape)shapes[i], (VoxelShape)SHAPE_CACHE[i][j][renderType]);
                }
            }
            if (Shapes.joinIsNotEmpty((VoxelShape)shapes[0], (VoxelShape)shapes[1], (BooleanOp)BooleanOp.AND) || Shapes.joinIsNotEmpty((VoxelShape)shapes[0], (VoxelShape)shapes[2], (BooleanOp)BooleanOp.AND) || Shapes.joinIsNotEmpty((VoxelShape)shapes[1], (VoxelShape)shapes[2], (BooleanOp)BooleanOp.AND)) {
                System.out.println("Intersecting configuration: " + Integer.toBinaryString(mask));
                ++intersectingConfigurations;
                return;
            }
            ++nonIntersectingConfigurations;
        }
        System.out.printf("Intersecting configurations: %d, non-intersecting configurations: %d\n", intersectingConfigurations, nonIntersectingConfigurations);
    }

    static {
        for (int slot = 0; slot < 3; ++slot) {
            for (Direction direction : Direction.values()) {
                int connectionTypes = slot == 0 ? 2 : (slot == 1 ? 4 : 5);
                for (int connectionType = 0; connectionType < connectionTypes; ++connectionType) {
                    PipeShapeBuilder psb = new PipeShapeBuilder(PipePartBuilder.getSlotPos(slot), direction);
                    if (connectionType == 0) {
                        psb.centerConnector();
                    } else if (connectionType == 1) {
                        psb.straightLine(false, false);
                    } else if (connectionType == 2) {
                        psb.shortBend(false, false);
                    } else if (connectionType == 3) {
                        psb.farShortBend(false, false);
                    } else {
                        psb.longBend(false, false);
                    }
                    PipeBlockEntity.SHAPE_CACHE[slot][direction.get3DDataValue()][connectionType] = psb.getShape();
                }
            }
        }
        DEFAULT_SHAPE = SHAPE_CACHE[0][0][0];
        ME_WIRE_CONNECTOR_SHAPES = PipeBlockEntity.buildSideShapes(0.5, 0.125);
    }

    record RenderAttachment(@Nullable BlockState camouflage, PipeNetworkType[] types, PipeEndpointType[][] renderedConnections, CompoundTag[] customData) {
        public static final ModelProperty<RenderAttachment> KEY = new ModelProperty();
    }
}

