/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeEndpointType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.impl.PipeMeshBuilder;
import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import aztech.modern_industrialization.pipes.impl.PipeRenderContext;
import aztech.modern_industrialization.thirdparty.fabricrendering.Mesh;
import aztech.modern_industrialization.thirdparty.fabricrendering.MeshBuilderImpl;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid.FluidVariantRendering;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;

public class PipeMeshCache
implements PipeRenderer {
    private final ConcurrentMap<ConnectionMeshKey, Mesh> connectionMeshes = new ConcurrentHashMap<ConnectionMeshKey, Mesh>(128, 0.5f);
    private final Function<ConnectionMeshKey, Mesh> connectionMeshBuilder;
    private final ConcurrentMap<CenterMeshKey, Mesh> centerMeshes = new ConcurrentHashMap<CenterMeshKey, Mesh>(128, 0.5f);
    private final Function<CenterMeshKey, Mesh> centerMeshBuilder;

    public PipeMeshCache(Function<Material, TextureAtlasSprite> textureGetter, Material[] spriteIds, boolean innerQuads) {
        this.connectionMeshBuilder = key -> {
            int i = key.endpointType;
            int logicalSlot = key.logicalSlot;
            Direction direction = Direction.from3DDataValue((int)key.directionId);
            int j = key.renderType;
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureGetter.apply(spriteIds[i]);
            MeshBuilderImpl meshBuilder = new MeshBuilderImpl();
            PipeMeshBuilder pmb = innerQuads ? new PipeMeshBuilder.InnerQuads(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite) : new PipeMeshBuilder(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite);
            boolean reduced = j >= 4;
            boolean end = i != 0;
            int renderType = j % 4;
            if (renderType == 0) {
                pmb.straightLine(reduced, end);
            } else if (renderType == 1) {
                pmb.shortBend(reduced, end);
            } else if (renderType == 2) {
                pmb.farShortBend(reduced, end);
            } else {
                pmb.longBend(reduced, end);
            }
            return meshBuilder.build();
        };
        TextureAtlasSprite sprite = textureGetter.apply(spriteIds[0]);
        this.centerMeshBuilder = key -> {
            int logicalSlot = key.logicalSlot;
            int mask = key.bitmask;
            MeshBuilderImpl meshBuilder = new MeshBuilderImpl();
            for (Direction direction : Direction.values()) {
                PipeMeshBuilder pmb = innerQuads ? new PipeMeshBuilder.InnerQuads(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite) : new PipeMeshBuilder(meshBuilder.getEmitter(), PipePartBuilder.getSlotPos(logicalSlot), direction, sprite);
                pmb.noConnection(mask);
            }
            return meshBuilder.build();
        };
    }

    @Override
    public void draw(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, PipeRenderContext ctx, int logicalSlot, PipeEndpointType[][] connections, CompoundTag customData) {
        int[] renderTypes = new int[6];
        Direction[] initialDirections = new Direction[6];
        int[] connectionsInDirection = new int[6];
        int directionsMask = 0;
        for (Direction direction : Direction.values()) {
            int i = direction.get3DDataValue();
            renderTypes[i] = PipePartBuilder.getRenderType(logicalSlot, direction, connections);
            if (renderTypes[i] == 0) continue;
            initialDirections[i] = PipePartBuilder.getInitialDirection(logicalSlot, direction, renderTypes[i]);
            int n = initialDirections[i].get3DDataValue();
            connectionsInDirection[n] = connectionsInDirection[n] + 1;
            directionsMask |= 1 << initialDirections[i].get3DDataValue();
        }
        if (customData.contains("fluid")) {
            FluidVariant fluid = NbtHelper.getFluidCompatible(customData, "fluid");
            TextureAtlasSprite still = FluidVariantRendering.getSprite(fluid);
            int color = FluidVariantRendering.getColor(fluid, view, pos);
            ctx.pushTransform(quad -> {
                if (quad.tag() == 1) {
                    if (still != null) {
                        quad.spriteBake(still, 4);
                        quad.color(color, color, color, color);
                        return true;
                    }
                    return false;
                }
                return true;
            });
        }
        for (int i = 0; i < 6; ++i) {
            PipeEndpointType endpointType = connections[logicalSlot][i];
            if (endpointType == null) continue;
            int renderType = renderTypes[i] - 1;
            if (connectionsInDirection[initialDirections[i].get3DDataValue()] > 1) {
                renderType += 4;
            }
            Mesh mesh = this.connectionMeshes.computeIfAbsent(new ConnectionMeshKey(endpointType.getId(), logicalSlot, i, renderType), this.connectionMeshBuilder);
            mesh.outputTo(ctx.getEmitter());
        }
        this.centerMeshes.computeIfAbsent(new CenterMeshKey(logicalSlot, directionsMask), this.centerMeshBuilder).outputTo(ctx.getEmitter());
        if (customData.contains("fluid")) {
            ctx.popTransform();
        }
    }

    private record ConnectionMeshKey(int endpointType, int logicalSlot, int directionId, int renderType) {
    }

    private record CenterMeshKey(int logicalSlot, int bitmask) {
    }
}

