/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.util.MISavedData;
import aztech.modern_industrialization.util.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;
import org.jetbrains.annotations.Nullable;

public class PipeNetworks
extends MISavedData {
    private static final SavedData.Factory<PipeNetworks> FACTORY = new SavedData.Factory(() -> new PipeNetworks(new HashMap<PipeNetworkType, PipeNetworkManager>()), PipeNetworks::readNbt);
    private static final String NAME = "modern_industrialization_pipe_networks";
    private final Map<PipeNetworkType, PipeNetworkManager> managers;
    private final Map<Long, List<Runnable>> loadPipesByChunk = new HashMap<Long, List<Runnable>>();

    public PipeNetworks(Map<PipeNetworkType, PipeNetworkManager> managers) {
        this.managers = managers;
    }

    public PipeNetworkManager getManager(PipeNetworkType type) {
        return this.managers.computeIfAbsent(type, PipeNetworkManager::new);
    }

    @Nullable
    public PipeNetworkManager getOptionalManager(PipeNetworkType type) {
        return this.managers.get(type);
    }

    public CompoundTag save(CompoundTag nbt) {
        for (Map.Entry<PipeNetworkType, PipeNetworkManager> entry : this.managers.entrySet()) {
            nbt.put(entry.getKey().getIdentifier().toString(), (Tag)entry.getValue().toTag(new CompoundTag()));
        }
        return nbt;
    }

    public static PipeNetworks readNbt(CompoundTag nbt) {
        HashMap<PipeNetworkType, PipeNetworkManager> managers = new HashMap<PipeNetworkType, PipeNetworkManager>();
        for (Map.Entry<ResourceLocation, PipeNetworkType> entry : PipeNetworkType.getTypes().entrySet()) {
            PipeNetworkManager manager = new PipeNetworkManager(entry.getValue());
            String tagKey = entry.getKey().toString();
            if (nbt.contains(tagKey)) {
                manager.fromNbt(nbt.getCompound(tagKey));
            }
            managers.put(entry.getValue(), manager);
        }
        return new PipeNetworks(managers);
    }

    public static PipeNetworks get(ServerLevel world) {
        PipeNetworks networks = (PipeNetworks)world.getDataStorage().computeIfAbsent(FACTORY, NAME);
        networks.setDirty();
        return networks;
    }

    public static void scheduleLoadPipe(Level world, PipeBlockEntity pipe) {
        if (world instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)world;
            if (!sw.getServer().isSameThread()) {
                throw new IllegalStateException("Can only load pipe on server from the server thread.");
            }
            PipeNetworks.get((ServerLevel)sw).loadPipesByChunk.computeIfAbsent(ChunkPos.asLong((BlockPos)pipe.getBlockPos()), chunk -> new ArrayList()).add(pipe::loadPipes);
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(TickEvent.LevelTickEvent.class, event -> {
            if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
                return;
            }
            ServerLevel world = (ServerLevel)event.level;
            PipeNetworks networks = PipeNetworks.get(world);
            Iterator<Map.Entry<Long, List<Runnable>>> it = networks.loadPipesByChunk.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, List<Runnable>> chunkEntry = it.next();
                if (!WorldHelper.isChunkTicking(world, chunkEntry.getKey())) continue;
                chunkEntry.getValue().forEach(Runnable::run);
                it.remove();
            }
            for (PipeNetworkManager manager : networks.managers.values()) {
                manager.tickNetworks(world);
            }
        });
    }
}

