/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.pipes.item.ExtractionSource;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

interface IItemSink {
    public static int listMoveAll(List<? extends IItemSink> sinks, ServerLevel world, ExtractionSource target, int sourceSlot, int maxAmount) {
        int moved = 0;
        for (IItemSink iItemSink : sinks) {
            if ((moved += iItemSink.moveAll(world, target, sourceSlot, maxAmount - moved)) >= maxAmount) break;
        }
        return moved;
    }

    public int moveAll(ServerLevel var1, ExtractionSource var2, int var3, int var4);

    public record HandlerWrapper(IItemHandler handler) implements IItemSink
    {
        @Override
        public int moveAll(ServerLevel world, ExtractionSource source, int sourceSlot, int maxToMove) {
            ItemStack simulateLeftover;
            int availableCount;
            int canFit;
            ItemStack available;
            IItemHandler sourceHandler = source.storage();
            int moved = 0;
            while (!(available = sourceHandler.extractItem(sourceSlot, maxToMove - moved, true)).isEmpty() && (canFit = (availableCount = available.getCount()) - (simulateLeftover = ItemHandlerHelper.insertItemStacked((IItemHandler)this.handler, (ItemStack)available, (boolean)true)).getCount()) > 0) {
                ItemStack taken = sourceHandler.extractItem(sourceSlot, canFit, false);
                int takenCount = taken.getCount();
                ItemStack leftover = ItemHandlerHelper.insertItemStacked((IItemHandler)this.handler, (ItemStack)taken, (boolean)false);
                int movedThisTime = takenCount - leftover.getCount();
                moved += movedThisTime;
                if (!leftover.isEmpty()) {
                    if ((leftover = sourceHandler.insertItem(sourceSlot, leftover, false)).isEmpty()) break;
                    MI.LOGGER.error("Discarding overflowing item {}, extracted from block at position {} in {}, accessed from {} side", new Object[]{leftover, source.queryPos(), world.dimension(), source.querySide()});
                    break;
                }
                if (movedThisTime != 0) continue;
                break;
            }
            return moved;
        }
    }
}

