/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.pipes.gui.iface.ConnectionTypeInterface;
import aztech.modern_industrialization.pipes.gui.iface.PriorityInterface;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface ItemPipeInterface
extends ConnectionTypeInterface,
PriorityInterface {
    public static final int SLOTS = 21;

    public boolean isWhitelist();

    public void setWhitelist(boolean var1);

    public ItemStack getStack(int var1);

    public void setStack(int var1, ItemStack var2);

    default public boolean isFilterEmpty() {
        for (int i = 0; i < 21; ++i) {
            if (this.getStack(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getUpgradeStack();

    public void setUpgradeStack(ItemStack var1);

    public boolean canUse(Player var1);

    public static ItemPipeInterface ofBuf(FriendlyByteBuf buf) {
        final boolean[] whitelist = new boolean[]{buf.readBoolean()};
        final int[] type = new int[]{buf.readInt()};
        final int[] priority = new int[]{buf.readInt(), buf.readInt()};
        final ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(21);
        for (int i = 0; i < 21; ++i) {
            stacks.add(buf.readItem());
        }
        final ItemStack[] upgradeStack = new ItemStack[]{buf.readItem()};
        return new ItemPipeInterface(){

            @Override
            public boolean isWhitelist() {
                return whitelist[0];
            }

            @Override
            public void setWhitelist(boolean newWhitelist) {
                whitelist[0] = newWhitelist;
            }

            @Override
            public ItemStack getStack(int slot) {
                return (ItemStack)stacks.get(slot);
            }

            @Override
            public void setStack(int slot, ItemStack stack) {
                stacks.set(slot, stack);
            }

            @Override
            public ItemStack getUpgradeStack() {
                return upgradeStack[0];
            }

            @Override
            public void setUpgradeStack(ItemStack stack) {
                upgradeStack[0] = stack;
            }

            @Override
            public int getConnectionType() {
                return type[0];
            }

            @Override
            public void setConnectionType(int type_) {
                type[0] = type_;
            }

            @Override
            public int getPriority(int channel) {
                return priority[channel];
            }

            @Override
            public void setPriority(int channel, int priority_) {
                priority[channel] = priority_;
            }

            @Override
            public boolean canUse(Player player) {
                return true;
            }
        };
    }

    default public void toBuf(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isWhitelist());
        buf.writeInt(this.getConnectionType());
        buf.writeInt(this.getPriority(0));
        buf.writeInt(this.getPriority(1));
        for (int i = 0; i < 21; ++i) {
            buf.writeItem(this.getStack(i));
        }
        buf.writeItem(this.getUpgradeStack());
    }
}

