/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.proxy;

import aztech.modern_industrialization.MIClient;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelBlockEntity;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelRenderer;
import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.blocks.storage.tank.TankRenderer;
import aztech.modern_industrialization.items.SteamDrillHooks;
import aztech.modern_industrialization.machines.gui.MachineMenuClient;
import aztech.modern_industrialization.machines.gui.MachineMenuCommon;
import aztech.modern_industrialization.machines.models.MachineBakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.models.UseBlockModelBakedModel;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
extends CommonProxy {
    @Override
    public Player getClientPlayer() {
        return (Player)Objects.requireNonNull(Minecraft.getInstance().player);
    }

    @Override
    @Nullable
    public Player findUser(ItemStack mainHand) {
        if (Minecraft.getInstance().isSameThread()) {
            for (AbstractClientPlayer player : Minecraft.getInstance().level.players()) {
                if (player.getMainHandItem() != mainHand) continue;
                return player;
            }
            return null;
        }
        return super.findUser(mainHand);
    }

    @Override
    public boolean shouldSteamDrillForceBreakReset() {
        HitResult hitResult;
        if (Minecraft.getInstance().isSameThread() && (hitResult = Minecraft.getInstance().hitResult) instanceof BlockHitResult) {
            BlockHitResult bhr = (BlockHitResult)hitResult;
            return bhr.getDirection() != SteamDrillHooks.breakingSide;
        }
        return false;
    }

    @Override
    public boolean hasShiftDown() {
        return Screen.hasShiftDown();
    }

    @Override
    public void withStandardItemRenderer(Consumer<?> stupidClientProperties) {
        stupidClientProperties.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return RenderHelper.BLOCK_AND_ENTITY_RENDERER;
            }
        });
    }

    @Override
    public void registerPartTankClient(Supplier<BlockEntityType<AbstractTankBlockEntity>> blockEntityType, int meanRgb) {
        MIClient.registerBlockEntityRenderer(blockEntityType, context -> new TankRenderer(TextureHelper.getOverlayTextColor(meanRgb)));
    }

    @Override
    public void registerPartBarrelClient(Supplier<BlockEntityType<BarrelBlockEntity>> blockEntityType, int meanRgb) {
        MIClient.registerBlockEntityRenderer(blockEntityType, context -> new BarrelRenderer(TextureHelper.getOverlayTextColor(meanRgb)));
    }

    @Override
    public MachineMenuCommon createClientMachineMenu(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        return MachineMenuClient.create(syncId, playerInventory, buf);
    }

    @Override
    public BlockState getMachineCasingBlockState(BlockState state, BlockAndTintGetter renderView, BlockPos pos) {
        BakedModel casingModel;
        BlockEntity be = renderView.getBlockEntity(pos);
        if (!(MIConfig.getConfig().enableInterMachineConnectedTextures || be instanceof HatchBlockEntity || be instanceof MultiblockMachineBlockEntity)) {
            return state;
        }
        ModelData modelData = renderView.getModelDataManager().getAtOrEmpty(pos);
        MachineModelClientData clientData = (MachineModelClientData)modelData.get(MachineModelClientData.KEY);
        if (clientData == null) {
            return state;
        }
        MachineCasing casing = clientData.casing;
        if (casing == null) {
            BakedModel machineModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
            if (machineModel instanceof MachineBakedModel) {
                MachineBakedModel mbm = (MachineBakedModel)machineModel;
                casing = mbm.getBaseCasing();
            } else {
                return state;
            }
        }
        if ((casingModel = MachineBakedModel.getCasingModel(casing)) instanceof UseBlockModelBakedModel) {
            UseBlockModelBakedModel ubmbm = (UseBlockModelBakedModel)casingModel;
            return ubmbm.getTargetState();
        }
        return state;
    }
}

