/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.resource;

import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class FastPathPackResources
extends PathPackResources {
    private final Path root;
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();

    public FastPathPackResources(String name, Path root, boolean isBuiltin) {
        super(name, root, isBuiltin);
        this.root = root;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        Path path = this.root.resolve(packType.getDirectory()).resolve(location.getNamespace());
        return FastPathPackResources.getResource(location, path);
    }

    public static IoSupplier<InputStream> getResource(ResourceLocation location, Path path) {
        return (IoSupplier)FileUtil.decomposePath((String)location.getPath()).get().map(list -> {
            Path path2 = FileUtil.resolvePath((Path)path, (List)list);
            return FastPathPackResources.returnFileIfExists(path2);
        }, partialResult -> null);
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path path) {
        return FastPathPackResources.exists(path) && FastPathPackResources.validatePath((Path)path) ? IoSupplier.create((Path)path) : null;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }
}

