/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.definition.FluidDefinition;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.textures.IORunnable;
import aztech.modern_industrialization.textures.PartTextureGenerator;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.Coloramp;
import aztech.modern_industrialization.textures.coloramp.IColoramp;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public final class MITextures {
    private static final String[] LAYERS = new String[]{"_underlay", "", "_overlay"};

    public static CompletableFuture<?> offerTextures(BiConsumer<NativeImage, String> textureWriter, BiConsumer<JsonElement, String> mcMetaWriter, ResourceProvider manager, ExistingFileHelper fileHelper) {
        TextureManager mtm = new TextureManager(manager, textureWriter, mcMetaWriter);
        ArrayList futures = new ArrayList();
        Consumer<IORunnable> defer = r -> futures.add(CompletableFuture.runAsync(r::safeRun, Util.backgroundExecutor()));
        for (Material material : MaterialRegistry.getMaterials().values()) {
            Integer meanRgb = material.get(MaterialProperty.MEAN_RGB);
            if (meanRgb == 0) {
                MI.LOGGER.error("Missing mean RGB for material {}", (Object)material.name);
                continue;
            }
            Coloramp coloramp = new Coloramp(mtm, meanRgb, material.name);
            for (MaterialItemPart part : material.getParts().values()) {
                defer.accept(() -> PartTextureGenerator.processPart(coloramp, mtm, material, part));
            }
        }
        for (FluidDefinition fluid : MIFluids.FLUID_DEFINITIONS.values()) {
            defer.accept(() -> MITextures.registerFluidTextures(mtm, fluid));
        }
        mtm.runAtEnd(() -> MITextures.casingFromTextureBricked(mtm, MachineCasings.BRICKED_BRONZE, MI.id("textures/block/bronze_machine_casing.png")));
        mtm.runAtEnd(() -> MITextures.casingFromTextureBricked(mtm, MachineCasings.BRICKED_STEEL, MI.id("textures/block/steel_machine_casing.png")));
        mtm.runAtEnd(() -> mtm.addTexture("modern_industrialization:textures/item/mixed_ingot_blastproof.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/stainless_steel_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/titanium_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/tungsten_ingot.png"))));
        mtm.runAtEnd(() -> mtm.addTexture("modern_industrialization:textures/item/mixed_plate_nuclear.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/cadmium_plate.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/beryllium_plate.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_plate.png"), 1, 2)));
        mtm.runAtEnd(() -> mtm.addTexture("modern_industrialization:textures/item/mixed_ingot_iridium.png", TextureHelper.tripleTexture(mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/iridium_ingot.png"), mtm.getAssetAsTexture("modern_industrialization:textures/item/blastproof_alloy_ingot.png"))));
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenComposeAsync(v -> mtm.doEndWork(), (Executor)Util.backgroundExecutor())).thenRun(() -> mtm.markTexturesAsGenerated(fileHelper))).thenRun(() -> MI.LOGGER.info("I used the png to destroy the png."));
    }

    private static String getTemplate(String materialSet, String part, String suffix) {
        return String.format("modern_industrialization:textures/materialsets/%s/%s%s.png", materialSet, part, suffix);
    }

    private static void colorizeLayer(NativeImage image, String layer, IColoramp coloramp) {
        if (layer.equals("")) {
            TextureHelper.colorize(image, coloramp);
        }
    }

    public static void generateItemPartTexture(TextureManager mtm, String partTemplate, @Nullable String overlay, String materialSet, String path, boolean isBlock, IColoramp coloramp) {
        try {
            NativeImage texture = MITextures.generateTexture(mtm, partTemplate, materialSet, coloramp);
            if (overlay != null) {
                String overlayTemplate = MITextures.getTemplate("common", overlay, "");
                NativeImage overlayTexture = mtm.getAssetAsTexture(overlayTemplate);
                NativeImage oldTexture = texture;
                texture = TextureHelper.blend(oldTexture, overlayTexture);
                oldTexture.close();
                overlayTexture.close();
            }
            MITextures.appendTexture(mtm, texture, path, isBlock);
            texture.close();
        }
        catch (Throwable throwable) {
            MITextures.logTextureGenerationError(throwable, path, materialSet, partTemplate);
        }
    }

    public static void generateItemPartTexture(TextureManager mtm, String partTemplate, String materialSet, String path, boolean isBlock, IColoramp coloramp) {
        MITextures.generateItemPartTexture(mtm, partTemplate, null, materialSet, path, isBlock, coloramp);
    }

    public static void logTextureGenerationError(Throwable throwable, String path, String materialSet, String part) {
        MI.LOGGER.warn(String.format("Failed to generate item part texture for path %s, material set %s, partTemplate %s", path, materialSet, part), throwable);
    }

    public static NativeImage generateTexture(TextureManager mtm, String partTemplate, String materialSet, IColoramp coloramp) throws IOException {
        NativeImage image = null;
        for (String layer : LAYERS) {
            String template = MITextures.getTemplate(materialSet, partTemplate, layer);
            if (!mtm.hasAsset(template)) {
                template = MITextures.getTemplate("common", partTemplate, layer);
            }
            if (!mtm.hasAsset(template)) continue;
            if (image == null) {
                image = mtm.getAssetAsTexture(template);
                MITextures.colorizeLayer(image, layer, coloramp);
                continue;
            }
            NativeImage topLayer = mtm.getAssetAsTexture(template);
            MITextures.colorizeLayer(topLayer, layer, coloramp);
            NativeImage oldImage = image;
            image = TextureHelper.blend(oldImage, topLayer);
            oldImage.close();
            topLayer.close();
        }
        return image;
    }

    public static void appendTexture(TextureManager mtm, NativeImage texture, String path, boolean isBlock) throws IOException {
        if (texture == null) {
            throw new RuntimeException("Could not find any texture!");
        }
        String texturePath = isBlock ? String.format("modern_industrialization:textures/block/%s.png", path) : String.format("modern_industrialization:textures/item/%s.png", path);
        mtm.addTexture(texturePath, texture);
        texture.close();
    }

    public static void generateDoubleIngot(TextureManager mtm, String materialName) throws IOException {
        String ingotTexture = String.format("modern_industrialization:textures/item/%s_ingot.png", materialName);
        if (materialName.equals("gold") || materialName.equals("iron") || materialName.equals("copper")) {
            ingotTexture = String.format("minecraft:textures/item/%s_ingot.png", materialName);
        }
        NativeImage image = mtm.getAssetAsTexture(ingotTexture);
        TextureHelper.doubleIngot(image);
        String itemPath = materialName + "_double_ingot";
        mtm.addTexture(String.format("modern_industrialization:textures/item/%s.png", itemPath), image);
        image.close();
    }

    public static void casingFromTexture(TextureManager tm, String casing, NativeImage texture) {
        for (String side : new String[]{"top", "side", "bottom"}) {
            try {
                String s = String.format("modern_industrialization:textures/block/casings/%s/%s.png", casing, side);
                tm.addTexture(s, TextureHelper.copy(texture));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void casingFromTextureBricked(TextureManager tm, MachineCasing casing, ResourceLocation topTexturePath) {
        try (NativeImage topTexture = tm.getAssetAsTexture(topTexturePath.toString());
             NativeImage brickTexture = tm.getAssetAsTexture("modern_industrialization:textures/block/fire_clay_bricks.png");){
            if (topTexture.getWidth() != brickTexture.getWidth() || topTexture.getHeight() != brickTexture.getHeight()) {
                throw new IllegalArgumentException("Texture and Brick must have same dimension");
            }
            try (NativeImage copy = TextureHelper.copy(topTexture);){
                for (int i = 0; i < copy.getWidth(); ++i) {
                    for (int j = copy.getHeight() / 2; j < copy.getHeight(); ++j) {
                        copy.setPixelRGBA(i, j, brickTexture.getPixelRGBA(i, j));
                    }
                }
                String s = String.format("modern_industrialization:textures/block/casings/%s.png", casing.name);
                tm.addTexture(s, copy);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate bricked casing texture", e);
        }
    }

    private static void registerFluidTextures(TextureManager tm, FluidDefinition fluid) {
        String path = "modern_industrialization:textures/fluid/";
        String bucket = path + "bucket.png";
        String bucket_content = path + "bucket_content.png";
        Coloramp fluidColoramp = new Coloramp(fluid.color);
        try {
            NativeImage bucket_image = tm.getAssetAsTexture(bucket);
            NativeImage bucket_content_image = tm.getAssetAsTexture(bucket_content);
            TextureHelper.colorize(bucket_content_image, fluidColoramp);
            NativeImage oldBucketImage = bucket_image;
            bucket_image = TextureHelper.blend(oldBucketImage, bucket_content_image);
            oldBucketImage.close();
            if (fluid.isGas) {
                TextureHelper.flip(bucket_image);
            }
            tm.addTexture(String.format("modern_industrialization:textures/item/%s_bucket.png", fluid.path()), bucket_image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String pathFluid = path + String.format("template/%s.png", fluid.fluidTexture.path);
        try {
            NativeImage fluidAnim = tm.getAssetAsTexture(pathFluid);
            TextureHelper.colorize(fluidAnim, fluidColoramp);
            TextureHelper.setAlpha(fluidAnim, fluid.opacity);
            tm.addTexture(String.format("modern_industrialization:textures/fluid/%s_still.png", fluid.path()), fluidAnim, true);
            tm.addMcMeta(String.format("modern_industrialization:textures/fluid/%s_still.png.mcmeta", fluid.path()), fluid.fluidTexture.mcMetaInfo);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

