/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.impl.fluid.FluidVariantImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface FluidVariant
extends TransferVariant<Fluid> {
    public static FluidVariant blank() {
        return FluidVariant.of(Fluids.EMPTY);
    }

    public static FluidVariant of(FluidStack stack) {
        return FluidVariant.of(stack.getFluid(), stack.getTag());
    }

    public static FluidVariant of(Fluid fluid) {
        return FluidVariant.of(fluid, null);
    }

    public static FluidVariant of(Fluid fluid, @Nullable CompoundTag nbt) {
        return FluidVariantImpl.of(fluid, nbt);
    }

    default public Fluid getFluid() {
        return (Fluid)this.getObject();
    }

    default public FluidStack toStack(int count) {
        if (this.isBlank()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(this.getFluid(), count);
        stack.setTag(this.copyNbt());
        return stack;
    }

    public static FluidVariant fromNbt(CompoundTag nbt) {
        return FluidVariantImpl.fromNbt(nbt);
    }

    public static FluidVariant fromPacket(FriendlyByteBuf buf) {
        return FluidVariantImpl.fromPacket(buf);
    }
}

