/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.api.item;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.impl.item.ItemVariantImpl;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface ItemVariant
extends TransferVariant<Item> {
    public static ItemVariant blank() {
        return ItemVariant.of((ItemLike)Items.AIR);
    }

    public static ItemVariant of(ItemStack stack) {
        return ItemVariant.of((ItemLike)stack.getItem(), stack.getTag(), stack.serializeAttachments());
    }

    public static ItemVariant of(ItemLike item) {
        return ItemVariant.of(item, null, null);
    }

    public static ItemVariant of(ItemLike item, @Nullable CompoundTag tag, @Nullable CompoundTag attachmentsTags) {
        return ItemVariantImpl.of(item.asItem(), tag, attachmentsTags);
    }

    default public boolean matches(ItemStack stack) {
        return this.isOf(stack.getItem()) && this.nbtMatches(stack.getTag()) && Objects.equals(this.getAttachments(), stack.serializeAttachments());
    }

    default public Item getItem() {
        return (Item)this.getObject();
    }

    @Nullable
    public CompoundTag getAttachments();

    default public ItemStack toStack() {
        return this.toStack(1);
    }

    default public ItemStack toStack(int count) {
        if (this.isBlank()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)this.getItem(), count, this.getAttachments());
        stack.setTag(this.copyNbt());
        return stack;
    }

    public static ItemVariant fromNbt(CompoundTag nbt) {
        return ItemVariantImpl.fromNbt(nbt);
    }

    public static ItemVariant fromPacket(FriendlyByteBuf buf) {
        return ItemVariantImpl.fromPacket(buf);
    }
}

