/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.impl.fluid;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluidVariantImpl
implements FluidVariant {
    private static final Map<Fluid, FluidVariant> noTagCache = new ConcurrentHashMap<Fluid, FluidVariant>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/fluid");
    private final Fluid fluid;
    @Nullable
    private final CompoundTag nbt;
    private final int hashCode;

    public static FluidVariant of(Fluid fluid, @Nullable CompoundTag nbt) {
        Objects.requireNonNull(fluid, "Fluid may not be null.");
        if (!fluid.isSource(fluid.defaultFluidState()) && fluid != Fluids.EMPTY) {
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowable = (FlowingFluid)fluid;
                fluid = flowable.getSource();
            } else {
                ResourceLocation id = BuiltInRegistries.FLUID.getKey((Object)fluid);
                throw new IllegalArgumentException("Cannot convert flowing fluid %s (%s) into a still fluid.".formatted(id, fluid));
            }
        }
        if (nbt == null || fluid == Fluids.EMPTY) {
            return noTagCache.computeIfAbsent(fluid, f -> new FluidVariantImpl((Fluid)f, null));
        }
        return new FluidVariantImpl(fluid, nbt);
    }

    public FluidVariantImpl(Fluid fluid, CompoundTag nbt) {
        this.fluid = fluid;
        this.nbt = nbt == null ? null : nbt.copy();
        this.hashCode = Objects.hash(fluid, nbt);
    }

    @Override
    public boolean isBlank() {
        return this.fluid == Fluids.EMPTY;
    }

    @Override
    public Fluid getObject() {
        return this.fluid;
    }

    @Override
    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag result = new CompoundTag();
        result.putString("fluid", BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString());
        if (this.nbt != null) {
            result.put("tag", (Tag)this.nbt.copy());
        }
        return result;
    }

    public static FluidVariant fromNbt(CompoundTag compound) {
        try {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(new ResourceLocation(compound.getString("fluid")));
            CompoundTag nbt = compound.contains("tag") ? compound.getCompound("tag") : null;
            return FluidVariantImpl.of(fluid, nbt);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid FluidVariant from NBT: {}", (Object)compound, (Object)runtimeException);
            return FluidVariant.blank();
        }
    }

    @Override
    public void toPacket(FriendlyByteBuf buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(BuiltInRegistries.FLUID.getId((Object)this.fluid));
            buf.writeNbt((Tag)this.nbt);
        }
    }

    public static FluidVariant fromPacket(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return FluidVariant.blank();
        }
        Fluid fluid = (Fluid)BuiltInRegistries.FLUID.byId(buf.readVarInt());
        CompoundTag nbt = buf.readNbt();
        return FluidVariantImpl.of(fluid, nbt);
    }

    public String toString() {
        return "FluidVariant{fluid=" + this.fluid + ", tag=" + this.nbt + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidVariantImpl fluidVariant = (FluidVariantImpl)o;
        return this.hashCode == fluidVariant.hashCode && this.fluid == fluidVariant.fluid && this.nbtMatches(fluidVariant.nbt);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

