/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabrictransfer.impl.item;

import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemVariantImpl
implements ItemVariant {
    private static final Map<Item, ItemVariant> noTagCache = new ConcurrentHashMap<Item, ItemVariant>();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-transfer-api-v1/item");
    private final Item item;
    @Nullable
    private final CompoundTag nbt;
    @Nullable
    private final CompoundTag attachments;
    private final int hashCode;

    public static ItemVariant of(Item item, @Nullable CompoundTag tag, @Nullable CompoundTag attachmentsTag) {
        Objects.requireNonNull(item, "Item may not be null.");
        if (tag == null && attachmentsTag == null || item == Items.AIR) {
            return noTagCache.computeIfAbsent(item, i -> new ItemVariantImpl((Item)i, null, null));
        }
        return new ItemVariantImpl(item, tag, attachmentsTag);
    }

    private ItemVariantImpl(Item item, CompoundTag nbt, CompoundTag attachmentsNbt) {
        this.item = item;
        this.nbt = nbt == null ? null : nbt.copy();
        this.attachments = attachmentsNbt == null ? null : attachmentsNbt.copy();
        this.hashCode = Objects.hash(item, nbt, attachmentsNbt);
    }

    @Override
    public Item getObject() {
        return this.item;
    }

    @Override
    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    @Nullable
    public CompoundTag getAttachments() {
        return this.attachments;
    }

    @Override
    public boolean isBlank() {
        return this.item == Items.AIR;
    }

    @Override
    public CompoundTag toNbt() {
        CompoundTag result = new CompoundTag();
        result.putString("item", BuiltInRegistries.ITEM.getKey((Object)this.item).toString());
        if (this.nbt != null) {
            result.put("tag", (Tag)this.nbt.copy());
        }
        if (this.attachments != null) {
            result.put("attachments", (Tag)this.attachments.copy());
        }
        return result;
    }

    public static ItemVariant fromNbt(CompoundTag tag) {
        try {
            Item item = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(tag.getString("item")));
            CompoundTag aTag = tag.contains("tag") ? tag.getCompound("tag") : null;
            CompoundTag attachmentsTag = tag.contains("attachments") ? tag.getCompound("attachments") : null;
            return ItemVariantImpl.of(item, aTag, attachmentsTag);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.debug("Tried to load an invalid ItemVariant from NBT: {}", (Object)tag, (Object)runtimeException);
            return ItemVariant.blank();
        }
    }

    @Override
    public void toPacket(FriendlyByteBuf buf) {
        if (this.isBlank()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(Item.getId((Item)this.item));
            buf.writeNbt((Tag)this.nbt);
            buf.writeNbt((Tag)this.attachments);
        }
    }

    public static ItemVariant fromPacket(FriendlyByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemVariant.blank();
        }
        Item item = Item.byId((int)buf.readVarInt());
        CompoundTag nbt = buf.readNbt();
        CompoundTag attachments = buf.readNbt();
        return ItemVariantImpl.of(item, nbt, attachments);
    }

    public String toString() {
        return "ItemVariant{item=" + this.item + ", tag=" + this.nbt + ", attachments=" + this.attachments + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemVariantImpl ItemVariant2 = (ItemVariantImpl)o;
        return this.hashCode == ItemVariant2.hashCode && this.item == ItemVariant2.item && this.nbtMatches(ItemVariant2.nbt) && Objects.equals(this.attachments, ItemVariant2.attachments);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

