/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.EmptyHandler;
import net.neoforged.neoforge.items.wrapper.ForwardingItemHandler;
import org.jetbrains.annotations.Nullable;

public class ItemHandlerItem
extends ForwardingItemHandler {
    private final SlotAccess slot;

    public ItemHandlerItem(SlotAccess slot, Function<ItemStack, @Nullable IItemHandler> getter) {
        super(() -> {
            IItemHandler cap = (IItemHandler)getter.apply(slot.get());
            return cap == null ? EmptyHandler.INSTANCE : cap;
        });
        this.slot = slot;
    }

    public ItemHandlerItem(SlotAccess slot) {
        this(slot, stack -> (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (simulate || this.slot.get().getCount() <= 1) {
            return super.insertItem(slot, stack, simulate);
        }
        return this.doOnCopy(() -> super.insertItem(slot, stack, false));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (simulate || this.slot.get().getCount() <= 1) {
            return super.extractItem(slot, amount, simulate);
        }
        return this.doOnCopy(() -> super.extractItem(slot, amount, false));
    }

    private ItemStack doOnCopy(Supplier<ItemStack> runnable) {
        ItemStack slotStack = this.slot.get();
        ItemStack stackCopy = slotStack.copy();
        stackCopy.shrink(1);
        slotStack.setCount(1);
        ItemStack ret = runnable.get();
        ItemStack newStack = this.slot.get();
        if (ItemStack.isSameItemSameTags((ItemStack)stackCopy, (ItemStack)newStack)) {
            stackCopy.grow(1);
        } else if (!newStack.isEmpty()) {
            // empty if block
        }
        this.slot.set(stackCopy);
        return ret;
    }
}

