/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;

public class MIExtraCodecs {
    public static final Codec<Float> FLOAT_01 = Codec.floatRange((float)0.0f, (float)1.0f);
    public static final Codec<Long> POSITIVE_LONG = MIExtraCodecs.longRange(1L, Long.MAX_VALUE);

    private static <N extends Number> Function<N, DataResult<N>> checkRange(N minInclusive, N maxInclusive) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(minInclusive) >= 0 && ((Comparable)((Object)value)).compareTo(maxInclusive) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> "Value " + value + " outside of range [" + minInclusive + ":" + maxInclusive + "]", (Object)value);
        };
    }

    static Codec<Long> longRange(long minInclusive, long maxInclusive) {
        Function<Long, DataResult<Long>> checker = MIExtraCodecs.checkRange(minInclusive, maxInclusive);
        return Codec.LONG.flatXmap(checker, checker);
    }

    public static <T> MapCodec<List<T>> maybeList(Codec<T> elementCodec, String field) {
        Codec listCodec = NeoForgeExtraCodecs.listWithOptionalElements((Codec)ConditionalOps.createConditionalCodec(elementCodec));
        Codec maybeListCodec = ExtraCodecs.either(elementCodec, (Codec)listCodec).xmap(either -> (List)either.map(List::of, Function.identity()), Either::right);
        return ExtraCodecs.strictOptionalField((Codec)maybeListCodec, (String)field, List.of());
    }

    public static <F, S> MapCodec<Either<F, S>> xor(MapCodec<F> first, MapCodec<S> second) {
        return new XorMapCodec<F, S>(first, second);
    }

    public static <T> MapCodec<T> optionalFieldAlwaysWrite(Codec<T> baseCodec, String field, T defaultValue) {
        return ExtraCodecs.strictOptionalField(baseCodec, (String)field).xmap(read -> read.orElse(defaultValue), Optional::of);
    }

    private static final class XorMapCodec<F, S>
    extends MapCodec<Either<F, S>> {
        private final MapCodec<F> first;
        private final MapCodec<S> second;

        private XorMapCodec(MapCodec<F> first, MapCodec<S> second) {
            this.first = first;
            this.second = second;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(this.first.keys(ops), this.second.keys(ops)).distinct();
        }

        public <T> DataResult<Either<F, S>> decode(DynamicOps<T> ops, MapLike<T> input) {
            DataResult firstResult = this.first.decode(ops, input).map(Either::left);
            DataResult secondResult = this.second.decode(ops, input).map(Either::right);
            Optional firstValue = firstResult.result();
            Optional secondValue = secondResult.result();
            if (firstValue.isPresent() && secondValue.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + firstValue.get() + " second: " + secondValue.get(), (Object)((Either)firstValue.get()));
            }
            if (firstValue.isPresent()) {
                return firstResult;
            }
            if (secondValue.isPresent()) {
                return secondResult;
            }
            return firstResult.apply2((x, y) -> y, secondResult);
        }

        public <T> RecordBuilder<T> encode(Either<F, S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return (RecordBuilder)input.map(x -> this.first.encode(x, ops, prefix), x -> this.second.encode(x, ops, prefix));
        }

        public String toString() {
            return "XorMapCodec[" + this.first + ", " + this.second + "]";
        }
    }
}

