/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.client.MIRenderTypes;
import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadBuffer;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.client.fluid.FluidVariantRendering;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class RenderHelper {
    private static final Supplier<BakedQuad[]> OVERLAY_QUADS;
    private static final float W = 0.05f;
    private static final MIIdentifier LOCKED_TEXTURE_LOCATION;
    private static final Supplier<BakedQuad[]> CUBE_QUADS;
    private static final float TANK_W = 0.0635f;
    public static final int FULL_LIGHT = 0xF000F0;
    private static final float[] DEFAULT_BRIGHTNESSES;
    public static final BlockEntityWithoutLevelRenderer BLOCK_AND_ENTITY_RENDERER;

    public static void drawOverlay(PoseStack ms, MultiBufferSource vcp, float r, float g, float b, int light, int overlay) {
        VertexConsumer vc = vcp.getBuffer(MIRenderTypes.solidHighlight());
        for (BakedQuad overlayQuad : OVERLAY_QUADS.get()) {
            RenderHelper.putBulkData(vc, ms.last(), overlayQuad, r, g, b, light, overlay);
        }
    }

    public static void drawCube(PoseStack ms, MultiBufferSource vcp, float r, float g, float b, int light, int overlay) {
        VertexConsumer vc = vcp.getBuffer(MIRenderTypes.solidHighlight());
        for (BakedQuad cubeQuad : CUBE_QUADS.get()) {
            RenderHelper.putBulkData(vc, ms.last(), cubeQuad, r, g, b, light, overlay);
        }
    }

    public static void drawFluidInTank(BlockEntity be, PoseStack ms, MultiBufferSource vcp, FluidVariant fluid, float fill) {
        RenderHelper.drawFluidInTank(be.getLevel(), be.getBlockPos(), ms, vcp, fluid, fill);
    }

    public static void drawFluidInTank(@Nullable Level world, BlockPos pos, PoseStack ms, MultiBufferSource vcp, FluidVariant fluid, float fill) {
        VertexConsumer vc = vcp.getBuffer(Sheets.translucentCullBlockSheet());
        TextureAtlasSprite sprite = FluidVariantRendering.getSprite(fluid);
        int color = FluidVariantRendering.getColor(fluid, (BlockAndTintGetter)world, pos);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        SodiumCompat.markSpriteActive(sprite);
        float topHeight = fill = 0.0635f + 0.873f * Math.min(1.0f, Math.max(fill, 0.0f));
        float bottomHeight = 0.0635f;
        if (fluid.getFluid().getFluidType().isLighterThanAir()) {
            topHeight = 0.9365f;
            bottomHeight = 1.0f - fill;
        }
        QuadBuffer emitter = new QuadBuffer();
        for (Direction direction : Direction.values()) {
            emitter.emit();
            if (direction.getAxis().isVertical()) {
                emitter.square(direction, 0.0635f, 0.0635f, 0.9365f, 0.9365f, direction == Direction.UP ? 1.0f - topHeight : bottomHeight);
            } else {
                emitter.square(direction, 0.0635f, bottomHeight, 0.9365f, topHeight, 0.0635f);
            }
            emitter.spriteBake(sprite, 4);
            emitter.color(-1, -1, -1, -1);
            vc.putBulkData(ms.last(), emitter.toBakedQuad(sprite), r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void drawFluidInGui(GuiGraphics guiGraphics, FluidVariant fluid, int i, int j) {
        RenderHelper.drawFluidInGui(guiGraphics, fluid, i, j, 16, 1.0f);
        RenderSystem.enableDepthTest();
    }

    public static void drawFluidInGui(GuiGraphics guiGraphics, FluidVariant fluid, float i, float j, int scale, float fractionUp) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite sprite = FluidVariantRendering.getSprite(fluid);
        int color = FluidVariantRendering.getColor(fluid);
        if (sprite == null) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        float x0 = i;
        float y0 = j;
        float x1 = x0 + (float)scale;
        float y1 = y0 + (float)scale * fractionUp;
        float z = 0.5f;
        float u0 = sprite.getU0();
        float v1 = sprite.getV1();
        float v0 = v1 + (sprite.getV0() - v1) * fractionUp;
        float u1 = sprite.getU1();
        Matrix4f model = guiGraphics.pose().last().pose();
        bufferBuilder.vertex(model, x0, y1, z).color(r, g, b, 1.0f).uv(u0, v1).endVertex();
        bufferBuilder.vertex(model, x1, y1, z).color(r, g, b, 1.0f).uv(u1, v1).endVertex();
        bufferBuilder.vertex(model, x1, y0, z).color(r, g, b, 1.0f).uv(u1, v0).endVertex();
        bufferBuilder.vertex(model, x0, y0, z).color(r, g, b, 1.0f).uv(u0, v0).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.enableDepthTest();
        SodiumCompat.markSpriteActive(sprite);
    }

    public static boolean isPointWithinRectangle(int xStart, int yStart, int width, int height, double pointX, double pointY) {
        return pointX >= (double)(xStart - 1) && pointX < (double)(xStart + width + 1) && pointY >= (double)(yStart - 1) && pointY < (double)(yStart + height + 1);
    }

    public static void quadWithAlpha(VertexConsumer consumer, PoseStack.Pose matrixEntry, BakedQuad quad, float red, float green, float blue, float alpha, int light, int overlay) {
        boolean useQuadColorData = false;
        float[] fs = DEFAULT_BRIGHTNESSES;
        int[] js = quad.getVertices();
        Vec3i vec3i = quad.getDirection().getNormal();
        Vector3f vec3f = new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ());
        Matrix4f matrix4f = matrixEntry.pose();
        vec3f.mul((Matrix3fc)matrixEntry.normal());
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float t;
                float s;
                float r;
                float w;
                float v;
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (useQuadColorData) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    v = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    w = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    r = l * fs[k] * red;
                    s = v * fs[k] * green;
                    t = w * fs[k] * blue;
                } else {
                    r = fs[k] * red;
                    s = fs[k] * green;
                    t = fs[k] * blue;
                }
                v = byteBuffer.getFloat(16);
                w = byteBuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, g, h, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                consumer.vertex(vector4f.x(), vector4f.y(), vector4f.z(), r, s, t, alpha, v, w, overlay, light, vec3f.x(), vec3f.y(), vec3f.z());
            }
        }
    }

    private static void putBulkData(VertexConsumer vc, PoseStack.Pose poseEntry, BakedQuad quad, float red, float green, float blue, int combinedLight, int combinedOverlay) {
        RenderHelper.putBulkData(vc, poseEntry, quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, new int[]{combinedLight, combinedLight, combinedLight, combinedLight}, combinedOverlay, false);
    }

    private static void putBulkData(VertexConsumer vc, PoseStack.Pose poseEntry, BakedQuad quad, float[] colorMuls, float red, float green, float blue, int[] combinedLights, int combinedOverlay, boolean mulColor) {
        float[] fs = new float[]{colorMuls[0], colorMuls[1], colorMuls[2], colorMuls[3]};
        int[] is = new int[]{combinedLights[0], combinedLights[1], combinedLights[2], combinedLights[3]};
        int[] js = quad.getVertices();
        Vec3i vec3i = quad.getDirection().getNormal();
        Matrix4f matrix4f = poseEntry.pose();
        Vector3f vector3f = poseEntry.normal().transform(new Vector3f((float)vec3i.getX(), (float)vec3i.getY(), (float)vec3i.getZ()));
        int j = js.length / 8;
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            ByteBuffer byteBuffer = memoryStack.malloc(DefaultVertexFormat.BLOCK.getVertexSize());
            IntBuffer intBuffer = byteBuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float q;
                float p;
                float o;
                float n;
                float m;
                intBuffer.clear();
                intBuffer.put(js, k * 8, 8);
                float f = byteBuffer.getFloat(0);
                float g = byteBuffer.getFloat(4);
                float h = byteBuffer.getFloat(8);
                if (mulColor) {
                    float l = (float)(byteBuffer.get(12) & 0xFF) / 255.0f;
                    m = (float)(byteBuffer.get(13) & 0xFF) / 255.0f;
                    n = (float)(byteBuffer.get(14) & 0xFF) / 255.0f;
                    o = l * fs[k] * red;
                    p = m * fs[k] * green;
                    q = n * fs[k] * blue;
                } else {
                    o = fs[k] * red;
                    p = fs[k] * green;
                    q = fs[k] * blue;
                }
                int r = is[k];
                m = byteBuffer.getFloat(16);
                n = byteBuffer.getFloat(20);
                Vector4f vector4f = matrix4f.transform(new Vector4f(f, g, h, 1.0f));
                vc.vertex(vector4f.x(), vector4f.y(), vector4f.z(), o, p, q, 1.0f, m, n, combinedOverlay, r, vector3f.x(), vector3f.y(), vector3f.z());
            }
        }
    }

    public static void fill(PoseStack matrices, int x1, int y1, int x2, int y2, int color) {
        RenderHelper.fill(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    private static void fill(Matrix4f matrix, int x1, int y1, int x2, int y2, int color) {
        int j;
        if (x1 < x2) {
            j = x1;
            x1 = x2;
            x2 = j;
        }
        if (y1 < y2) {
            j = y1;
            y1 = y2;
            y2 = j;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.vertex(matrix, (float)x1, (float)y2, 0.0f).color(g, h, k, f).endVertex();
        bufferBuilder.vertex(matrix, (float)x2, (float)y2, 0.0f).color(g, h, k, f).endVertex();
        bufferBuilder.vertex(matrix, (float)x2, (float)y1, 0.0f).color(g, h, k, f).endVertex();
        bufferBuilder.vertex(matrix, (float)x1, (float)y1, 0.0f).color(g, h, k, f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.disableBlend();
    }

    public static void drawLockedTexture(BlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, int colorRgb) {
        VertexConsumer vc = vertexConsumers.getBuffer(Sheets.cutoutBlockSheet());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(LOCKED_TEXTURE_LOCATION);
        BlockPos pos = entity.getBlockPos();
        BlockState state = entity.getBlockState();
        float r = (float)(colorRgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(colorRgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(colorRgb & 0xFF) / 255.0f;
        QuadBuffer emitter = new QuadBuffer();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis().isVertical() || entity.getLevel() != null && !Block.shouldRenderFace((BlockState)state, (BlockGetter)entity.getLevel(), (BlockPos)pos, (Direction)direction.getOpposite(), (BlockPos)pos.relative(direction.getOpposite()))) continue;
            emitter.emit();
            emitter.square(direction, 1.0f, 0.0f, 0.0f, 1.0f, 1.015f);
            emitter.spriteBake(sprite, 4);
            vc.putBulkData(matrices.last(), emitter.toBakedQuad(sprite), r, g, b, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void renderVoxelShape(PoseStack poseStack, VertexConsumer consumer, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        for (AABB aabb : shape.toAabbs()) {
            LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)consumer, (VoxelShape)Shapes.create((AABB)aabb), (double)x, (double)y, (double)z, (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        RenderHelper.renderAndDecorateItem(guiGraphics, Minecraft.getInstance().font, stack, x, y);
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, Font font, ItemStack stack, int x, int y) {
        RenderHelper.renderAndDecorateItem(guiGraphics, font, stack, x, y, null);
    }

    public static void renderAndDecorateItem(GuiGraphics guiGraphics, Font font, ItemStack stack, int x, int y, @Nullable String text) {
        guiGraphics.renderItem(stack, x, y);
        guiGraphics.renderItemDecorations(font, stack, x, y, text);
    }

    static {
        LOCKED_TEXTURE_LOCATION = new MIIdentifier("block/locked");
        OVERLAY_QUADS = Suppliers.memoize(() -> {
            BakedQuad[] overlayQuads = new BakedQuad[24];
            QuadBuffer emitter = new QuadBuffer();
            for (Direction direction : Direction.values()) {
                emitter.emit();
                emitter.square(direction, 0.0f, 0.0f, 1.0f, 0.05f, 0.0f);
                overlayQuads[direction.get3DDataValue() * 4] = emitter.toBakedQuad(null);
                emitter.square(direction, 0.0f, 0.95f, 1.0f, 1.0f, 0.0f);
                overlayQuads[direction.get3DDataValue() * 4 + 1] = emitter.toBakedQuad(null);
                emitter.square(direction, 0.0f, 0.05f, 0.05f, 0.95f, 0.0f);
                overlayQuads[direction.get3DDataValue() * 4 + 2] = emitter.toBakedQuad(null);
                emitter.square(direction, 0.95f, 0.05f, 1.0f, 0.95f, 0.0f);
                overlayQuads[direction.get3DDataValue() * 4 + 3] = emitter.toBakedQuad(null);
            }
            return overlayQuads;
        });
        CUBE_QUADS = Suppliers.memoize(() -> {
            BakedQuad[] cubeQuads = new BakedQuad[6];
            for (Direction direction : Direction.values()) {
                QuadBuffer emitter = new QuadBuffer();
                emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
                cubeQuads[direction.get3DDataValue()] = emitter.toBakedQuad(null);
            }
            return cubeQuads;
        });
        DEFAULT_BRIGHTNESSES = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        BLOCK_AND_ENTITY_RENDERER = new BlockEntityWithoutLevelRenderer(null, null){

            public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
                Item item = stack.getItem();
                if (!(item instanceof BlockItem)) {
                    throw new IllegalArgumentException("Stack must be a block item!");
                }
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                if (!(block instanceof EntityBlock)) {
                    throw new IllegalArgumentException("Block must be an entity block!");
                }
                EntityBlock entityBlock = (EntityBlock)block;
                BlockEntity fakeBlockEntity = entityBlock.newBlockEntity(BlockPos.ZERO, blockItem.getBlock().defaultBlockState());
                CompoundTag tag = Objects.requireNonNullElseGet(stack.getTagElement("BlockEntityTag"), CompoundTag::new);
                Objects.requireNonNull(fakeBlockEntity).load(tag);
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(fakeBlockEntity.getBlockState(), matrices, vertexConsumers, light, overlay);
                BlockEntityRenderer renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(fakeBlockEntity);
                Objects.requireNonNull(renderer).render(fakeBlockEntity, Minecraft.getInstance().getFrameTime(), matrices, vertexConsumers, light, overlay);
            }
        };
    }
}

