/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import aztech.modern_industrialization.MI;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class TransferHelper {
    public static void moveAll(IItemHandler src, IItemHandler target, boolean stackInTarget) {
        int srcSlots = src.getSlots();
        for (int i = 0; i < srcSlots; ++i) {
            ItemStack leftover;
            ItemStack extracted = src.extractItem(i, Integer.MAX_VALUE, true);
            if (extracted.isEmpty()) continue;
            int extractedCount = extracted.getCount();
            int insertedCount = extractedCount - (leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)true) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)true)).getCount();
            if (insertedCount <= 0 || (extracted = src.extractItem(i, insertedCount, false)).isEmpty()) continue;
            ItemStack itemStack = leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)false) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)false);
            if (leftover.isEmpty() || (leftover = src.insertItem(i, leftover, false)).isEmpty()) continue;
            MI.LOGGER.warn("Item handler {} rejected {}, discarding.", (Object)target, (Object)leftover);
        }
    }

    public static ItemStack extractMatching(IItemHandler src, Predicate<ItemStack> predicate, int maxAmount) {
        ItemStack stack;
        int slot;
        int srcSlots = src.getSlots();
        ItemStack ret = ItemStack.EMPTY;
        for (slot = 0; slot < srcSlots && ret.isEmpty(); ++slot) {
            stack = src.getStackInSlot(slot);
            if (!predicate.test(stack)) continue;
            ret = src.extractItem(slot, maxAmount, false);
        }
        if (ret.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ++slot;
        while (slot < srcSlots && maxAmount < ret.getCount()) {
            stack = src.getStackInSlot(slot);
            if (ItemStack.matches((ItemStack)stack, (ItemStack)ret)) {
                ItemStack extracted = src.extractItem(slot, maxAmount - ret.getCount(), true);
                ret.grow(extracted.getCount());
            }
            ++slot;
        }
        return ret;
    }
}

