/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.jei;

import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.JEIRecipeTypes;
import dev.ftb.mods.ftbxmodcompat.ftbquests.jei.QuestCategory;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedQuestCache;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;

public enum QuestRecipeManagerPlugin implements IRecipeManagerPlugin
{
    INSTANCE;

    private final WrappedQuestCache cache = new WrappedQuestCache();

    public void refresh() {
        this.cache.clear();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object;
        if (recipeCategory instanceof QuestCategory && (object = focus.getTypedValue().getIngredient()) instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (stack.getItem() == FTBQuestsItems.BOOK.get() && focus.getRole() == RecipeIngredientRole.CATALYST) {
                return this.cache.getCachedItems();
            }
            return switch (focus.getRole()) {
                case RecipeIngredientRole.INPUT -> this.cache.findQuestsWithInput(stack);
                case RecipeIngredientRole.OUTPUT -> this.cache.findQuestsWithOutput(stack);
                default -> List.of();
            };
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return recipeCategory instanceof QuestCategory ? this.cache.getCachedItems() : List.of();
    }

    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (focus.getRole() == RecipeIngredientRole.INPUT && (stack.getItem() == FTBQuestsItems.BOOK.get() || !this.cache.findQuestsWithInput(stack).isEmpty()) || focus.getRole() == RecipeIngredientRole.OUTPUT && !this.cache.findQuestsWithOutput(stack).isEmpty()) {
                return List.of(JEIRecipeTypes.QUEST);
            }
        }
        return List.of();
    }
}

