/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.rei;

import dev.architectury.fluid.FluidStack;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedLootCrate;
import dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common.WrappedQuest;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.LootCrateDisplay;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.LootCrateDisplayCategory;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.LootCrateDisplayGenerator;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.QuestDisplay;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.QuestDisplayCategory;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.QuestDisplayGenerator;
import dev.ftb.mods.ftbxmodcompat.ftbquests.rei.REICategories;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.world.item.ItemStack;

public class FTBQuestsREIIntegration
implements REIClientPlugin {
    private static BasicFilteringRule.MarkDirty cratesChanged;

    public void registerCategories(CategoryRegistry registry) {
        if (FTBXModCompat.isFTBQuestsLoaded) {
            registry.add((DisplayCategory)new QuestDisplayCategory());
            registry.add((DisplayCategory)new LootCrateDisplayCategory());
        }
    }

    public void registerDisplays(DisplayRegistry registry) {
        if (FTBXModCompat.isFTBQuestsLoaded) {
            registry.registerFiller(WrappedQuest.class, QuestDisplay::new);
            registry.registerFiller(WrappedLootCrate.class, LootCrateDisplay::new);
            registry.registerDisplayGenerator(REICategories.QUEST, (DynamicDisplayGenerator)QuestDisplayGenerator.INSTANCE);
            registry.registerDisplayGenerator(REICategories.LOOT_CRATE, (DynamicDisplayGenerator)LootCrateDisplayGenerator.INSTANCE);
        }
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        if (FTBXModCompat.isFTBQuestsLoaded) {
            cratesChanged = rule.show(LootCrateDisplayGenerator.INSTANCE::getCrateEntryStacks);
        }
    }

    public static void showRecipes(ItemStack stack) {
        FTBQuestsREIIntegration.showRecipes(stack, VanillaEntryTypes.ITEM);
    }

    public static void showRecipes(FluidStack stack) {
        FTBQuestsREIIntegration.showRecipes(stack, VanillaEntryTypes.FLUID);
    }

    private static <T> void showRecipes(T stack, EntryType<T> type) {
        EntryDefinition definition = EntryTypeRegistry.getInstance().get(type);
        if (definition != null) {
            ViewSearchBuilder.builder().addRecipesFor(EntryStack.of((EntryDefinition)definition, stack)).open();
        }
    }

    public static void onLootCratesChanged() {
        if (cratesChanged != null) {
            cratesChanged.markDirty();
        }
    }
}

