/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.generic.permissions;

import dev.ftb.mods.ftblibrary.integration.permissions.PermissionProvider;
import java.util.Optional;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.server.level.ServerPlayer;

public class LuckPermsProvider
implements PermissionProvider {
    public int getIntegerPermission(ServerPlayer player, String nodeName, int def) {
        return LuckPermsProvider.getMetaData(player.getUUID(), nodeName).map(Integer::parseInt).orElse(def);
    }

    public boolean getBooleanPermission(ServerPlayer player, String nodeName, boolean def) {
        return LuckPermsProvider.getMetaData(player.getUUID(), nodeName).map(Boolean::parseBoolean).orElse(def);
    }

    public String getStringPermission(ServerPlayer player, String nodeName, String def) {
        return LuckPermsProvider.getMetaData(player.getUUID(), nodeName).orElse(def);
    }

    public String getName() {
        return "LuckPerms";
    }

    private static Optional<String> getMetaData(UUID uuid, String meta) {
        LuckPerms luckperms = net.luckperms.api.LuckPermsProvider.get();
        Optional<String> metaValue = Optional.empty();
        try {
            Optional context;
            User user = luckperms.getUserManager().getUser(uuid);
            if (user != null && (context = luckperms.getContextManager().getQueryOptions(user)).isPresent()) {
                metaValue = Optional.ofNullable(user.getCachedData().getMetaData((QueryOptions)context.get()).getMetaValue(meta));
            }
        }
        catch (IllegalStateException e) {
            System.err.println("Error on fetching user with luckperms");
            System.err.println(e.getMessage());
        }
        return metaValue;
    }
}

