/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.backupmanager;

import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.backupmanager.providers.Backup;
import net.creeperhost.backupmanager.providers.BackupProvider;
import net.creeperhost.backupmanager.providers.FTBBackupProvider;
import net.creeperhost.backupmanager.providers.SimpleBackupsProvider;
import net.creeperhost.backupmanager.providers.VanillaBackupProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupManager {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "backupmanager";
    private static Path mcPath;
    private static Path savesPath;
    private static List<BackupProvider> providerList;
    private static Map<String, Backup> backups;

    public static void init() throws IOException {
        mcPath = Platform.getGameFolder();
        savesPath = mcPath.resolve("saves");
        if (Platform.isModLoaded((String)"ftbbackups2")) {
            BackupManager.addProvider(new FTBBackupProvider());
        }
        if (Platform.isModLoaded((String)"simplebackups")) {
            BackupManager.addProvider(new SimpleBackupsProvider());
        }
        BackupManager.addProvider(new VanillaBackupProvider());
    }

    public static void addProvider(BackupProvider provider) {
        providerList.add(provider);
    }

    public static void refreshBackups() {
        backups.clear();
        for (BackupProvider provider : providerList) {
            try {
                List<Backup> results = provider.getBackups();
                for (Backup result : results) {
                    if (backups.containsKey(result.backupLocation())) continue;
                    backups.put(result.backupLocation(), result);
                }
            }
            catch (IOException ex) {
                LOGGER.error("An error occurred while attempting to get backups for provider: {}", (Object)provider.getClass().getName(), (Object)ex);
            }
        }
    }

    public static boolean hasBackups() {
        if (backups.isEmpty()) {
            BackupManager.refreshBackups();
        }
        return !backups.isEmpty();
    }

    public static Map<String, Backup> getBackups() {
        return backups;
    }

    public static Path getMcPath() {
        return mcPath;
    }

    public static Path getSavesPath() {
        return savesPath;
    }

    static {
        providerList = new ArrayList<BackupProvider>();
        backups = new HashMap<String, Backup>();
    }
}

