/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.backupmanager.providers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.backupmanager.BackupManager;
import net.creeperhost.backupmanager.providers.Backup;
import net.creeperhost.backupmanager.providers.BackupException;
import net.creeperhost.backupmanager.providers.BackupProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.network.chat.Component;
import org.apache.commons.io.FileUtils;

public class SimpleBackupsProvider
implements BackupProvider {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    @Override
    public List<Backup> getBackups() throws IOException {
        Path config = BackupManager.getMcPath().resolve("config/simplebackups-common.toml");
        if (!Files.exists(config, new LinkOption[0])) {
            return Collections.emptyList();
        }
        String backupDir = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(config, new OpenOption[0])));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("outputPath") || !line.contains("=")) continue;
                backupDir = line.substring(line.indexOf("=") + 1).trim().replace("\"", "");
                break;
            }
        }
        if (backupDir == null) {
            return Collections.emptyList();
        }
        Path backups = BackupManager.getMcPath().resolve(backupDir);
        if (!Files.isDirectory(backups, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<Backup> results = new ArrayList<Backup>();
        List<Path> files = Files.list(backups).toList();
        for (Path file : files) {
            long timestamp;
            String fileName;
            if (!file.getFileName().toString().endsWith(".zip") || !(fileName = file.getFileName().toString()).contains("_")) continue;
            int i = fileName.lastIndexOf("_");
            String date = fileName.substring(i);
            if (!(fileName = fileName.substring(0, i)).contains("_")) continue;
            i = fileName.lastIndexOf("_");
            date = (fileName.substring(i + 1) + date).replace(".zip", "");
            fileName = fileName.substring(0, i);
            try {
                timestamp = DATE_FORMAT.parse(date).getTime();
            }
            catch (ParseException e) {
                continue;
            }
            results.add(new SimpleBackup(file.toAbsolutePath().toString(), fileName, timestamp));
        }
        return results;
    }

    public static class SimpleBackup
    implements Backup {
        private transient FaviconTexture icon = null;
        private final String location;
        private final String name;
        private final long timestamp;

        public SimpleBackup(String location, String name, long timestamp) {
            this.location = location;
            this.name = name;
            this.timestamp = timestamp;
        }

        @Override
        public FaviconTexture getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(FaviconTexture icon) {
            this.icon = icon;
        }

        @Override
        public List<Component> hoverText() {
            return List.of(Component.translatable((String)"backupmanager:gui.backups.file_location"), Component.literal((String)this.location).withStyle(ChatFormatting.GRAY));
        }

        @Override
        public String backupLocation() {
            return this.location;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String displayName() {
            return "";
        }

        @Override
        public long creationTime() {
            return this.timestamp;
        }

        @Override
        public String backupProvider() {
            return ChatFormatting.GRAY + "Simple Backups";
        }

        @Override
        public void delete() throws BackupException {
            File backup = new File(this.location);
            if (!backup.isFile()) {
                throw new BackupException((Component)Component.literal((String)("Backup file not found: " + this.location)));
            }
            if (!backup.delete()) {
                throw new BackupException((Component)Component.literal((String)("Failed do delete backup file! You may need to delete the file manually: " + this.location)));
            }
        }

        @Override
        public void restore(String restoreName) throws BackupException {
            FileSystem fileSystem = FileSystems.getDefault();
            Path backup = fileSystem.getPath(this.location, new String[0]);
            if (!Files.exists(backup, new LinkOption[0])) {
                throw new BackupException((Component)Component.literal((String)("Backup file not found: " + this.location)));
            }
            Path worldFolder = BackupManager.getSavesPath().resolve(this.getWorldFolderName(restoreName));
            Path temp = this.getTempDirectory();
            this.unzip(backup, temp);
            this.smartMove(temp, worldFolder);
            try {
                this.setWorldName(worldFolder, restoreName);
            }
            catch (BackupException ex) {
                throw new BackupException((Component)Component.literal((String)"World was extracted but name could not be set. \nReason:\n").append(ex.getComponent()));
            }
            finally {
                try {
                    if (Files.exists(temp, new LinkOption[0])) {
                        FileUtils.deleteDirectory((File)temp.toFile());
                    }
                }
                catch (IOException e) {
                    BackupManager.LOGGER.error("Backup was restored but the temporary directory could not be deleted. " + e);
                }
            }
        }
    }
}

