/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientActionCallback;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

@Info(value="Various Ingredient related helper methods")
public interface IngredientWrapper {
    @Info(value="A completely empty ingredient that will only match air")
    public static final Ingredient none = Ingredient.EMPTY;
    @Info(value="An ingredient that matches everything")
    public static final Ingredient all = IngredientHelper.get().wildcard();

    @Info(value="Returns an ingredient of the input")
    public static Ingredient of(Ingredient ingredient) {
        return ingredient;
    }

    @Info(value="Returns an ingredient of the input, with the specified count")
    public static InputItem of(Ingredient ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    @Info(value="Register a custom ingredient action for use in recipes with Recipe#customIngredientAction")
    public static void registerCustomIngredientAction(String id, CustomIngredientActionCallback callback) {
        CustomIngredientAction.MAP.put(id, callback);
    }

    @Info(value="Checks if the passed in object is an Ingredient.\nNote that this does not mean it will not function as an Ingredient if passed to something that requests one.\n")
    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof Ingredient;
    }
}

