/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityEventCallback;
import dev.latvian.mods.kubejs.block.entity.BlockEntityInfo;
import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityJS
extends BlockEntity {
    public final BlockEntityInfo info;
    protected BlockContainerJS block;
    public final int x;
    public final int y;
    public final int z;
    public int tick;
    public int cycle;
    public CompoundTag data;
    public final BlockEntityAttachment[] attachments;
    public InventoryKJS inventory;
    public UUID placerId;

    public BlockEntityJS(BlockPos blockPos, BlockState blockState, BlockEntityInfo entityInfo) {
        super(entityInfo.entityType, blockPos, blockState);
        this.info = entityInfo;
        this.x = blockPos.getX();
        this.y = blockPos.getY();
        this.z = blockPos.getZ();
        this.tick = 0;
        this.cycle = 0;
        this.data = this.info.initialData.copy();
        if (entityInfo.attachments != null) {
            this.attachments = new BlockEntityAttachment[entityInfo.attachments.size()];
            for (int i = 0; i < this.attachments.length; ++i) {
                InventoryKJS inv;
                BlockEntityAttachment blockEntityAttachment;
                this.attachments[i] = entityInfo.attachments.get(i).factory().create(this);
                if (this.inventory != null || !((blockEntityAttachment = this.attachments[i]) instanceof InventoryKJS)) continue;
                this.inventory = inv = (InventoryKJS)((Object)blockEntityAttachment);
            }
        } else {
            this.attachments = BlockEntityAttachment.EMPTY_ARRAY;
        }
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("data", (Tag)this.data);
        if (this.tick > 0) {
            tag.putInt("tick", this.tick);
        }
        if (this.cycle > 0) {
            tag.putInt("cycle", this.cycle);
        }
        if (this.placerId != null) {
            tag.putUUID("placer", this.placerId);
        }
        if (this.attachments.length > 0) {
            ListTag list = new ListTag();
            for (BlockEntityAttachment att : this.attachments) {
                list.add((Object)att.writeAttachment());
            }
            tag.put("attachments", (Tag)list);
        }
    }

    public void load(CompoundTag tag) {
        block4: {
            super.load(tag);
            this.data = tag.getCompound("data");
            this.tick = tag.getInt("tick");
            this.cycle = tag.getInt("cycle");
            UUID uUID = this.placerId = tag.contains("placer") ? tag.getUUID("placer") : null;
            if (this.attachments.length <= 0) break block4;
            ListTag list = tag.getList("attachments", 10);
            if (this.attachments.length == list.size()) {
                for (int i = 0; i < this.attachments.length; ++i) {
                    this.attachments[i].readAttachment(list.getCompound(i));
                }
            } else {
                for (BlockEntityAttachment att : this.attachments) {
                    att.readAttachment(new CompoundTag());
                }
            }
        }
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        if (this.info.sync && !this.data.isEmpty()) {
            tag.put("data", (Tag)this.data);
        }
        if (this.tick > 0) {
            tag.putInt("tick", this.tick);
        }
        if (this.cycle > 0) {
            tag.putInt("cycle", this.cycle);
        }
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void save() {
        if (this.level != null) {
            this.level.blockEntityChanged(this.worldPosition);
        }
    }

    public void sync() {
        if (this.level != null) {
            this.save();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
        }
    }

    public void sendEvent(int eventId, int data) {
        this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), eventId, data);
    }

    public boolean triggerEvent(int eventId, int data) {
        BlockEntityEventCallback e;
        if (this.info.eventHandlers != null && (e = (BlockEntityEventCallback)this.info.eventHandlers.get(eventId)) != null) {
            e.accept(this, data);
            return true;
        }
        return false;
    }

    @HideFromJS
    public void postTick(boolean c) {
        ++this.tick;
        if (c) {
            ++this.cycle;
        }
    }

    public BlockContainerJS getBlock() {
        if (this.block == null) {
            this.block = new BlockContainerJS(this.level, this.worldPosition);
            this.block.cachedEntity = this;
        }
        return this.block;
    }
}

