/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachment;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentType;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.typings.desc.PrimitiveDescJS;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InventoryAttachment
extends SimpleContainer
implements BlockEntityAttachment {
    public static final BlockEntityAttachmentType TYPE = new BlockEntityAttachmentType("inventory", TypeDescJS.object().add("xsize", TypeDescJS.NUMBER, false).add("ysize", TypeDescJS.NUMBER, false).add("inputFilter", new PrimitiveDescJS("Ingredient"), true), map -> {
        int width = ((Number)map.get("width")).intValue();
        int height = ((Number)map.get("height")).intValue();
        Ingredient inputFilter = map.containsKey("inputFilter") ? IngredientJS.of(map.get("inputFilter")) : null;
        return entity -> new InventoryAttachment(entity, width, height, inputFilter);
    });
    public final int width;
    public final int height;
    public final BlockEntityJS blockEntity;
    public final Ingredient inputFilter;

    public InventoryAttachment(BlockEntityJS blockEntity, int width, int height, @Nullable Ingredient inputFilter) {
        super(width * height);
        this.width = width;
        this.height = height;
        this.blockEntity = blockEntity;
        this.inputFilter = inputFilter;
    }

    public void setChanged() {
        super.setChanged();
        this.blockEntity.save();
    }

    @Override
    public CompoundTag writeAttachment() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            stack.save(itemTag);
            list.add((Object)itemTag);
        }
        tag.put("items", (Tag)list);
        return tag;
    }

    @Override
    public void readAttachment(CompoundTag tag) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.removeItemNoUpdate(i);
        }
        ListTag list = tag.getList("items", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.getCompound(i);
            byte slot = itemTag.getByte("Slot");
            if (slot < 0 || slot >= this.getContainerSize()) continue;
            this.setItem(slot, ItemStack.of((CompoundTag)itemTag));
        }
    }

    @Override
    public void onRemove(BlockState newState) {
        Containers.dropContents((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos(), (Container)this);
    }

    public boolean canAddItem(ItemStack itemStack) {
        return (this.inputFilter == null || this.inputFilter.test(itemStack)) && super.canAddItem(itemStack);
    }

    public boolean canPlaceItem(int i, ItemStack itemStack) {
        return (this.inputFilter == null || this.inputFilter.test(itemStack)) && super.canPlaceItem(i, itemStack);
    }

    public boolean stillValid(Player player) {
        return !this.blockEntity.isRemoved();
    }

    public int kjs$getWidth() {
        return this.width;
    }

    public int kjs$getHeight() {
        return this.height;
    }
}

