/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client.painter.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.PainterObjectProperties;
import dev.latvian.mods.kubejs.client.painter.screen.BoxObject;
import dev.latvian.mods.kubejs.client.painter.screen.PaintScreenEventJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.unit.FixedBooleanUnit;
import dev.latvian.mods.unit.FixedNumberUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ItemObject
extends BoxObject {
    public ItemStack itemStack = ItemStack.EMPTY;
    public Unit overlay = FixedBooleanUnit.TRUE;
    public String customText = "";
    public Unit rotation = FixedNumberUnit.ZERO;

    public ItemObject(Painter painter) {
        super(painter);
        this.z = FixedNumberUnit.of((double)100.0);
    }

    @Override
    protected void load(PainterObjectProperties properties) {
        super.load(properties);
        if (properties.hasAny("item")) {
            this.itemStack = ItemStackJS.of(properties.tag.get("item"));
        }
        this.overlay = properties.getUnit("overlay", this.overlay);
        this.customText = properties.getString("customText", this.customText);
        this.rotation = properties.getUnit("rotation", this.rotation);
    }

    @Override
    public void draw(PaintScreenEventJS event) {
        if (this.itemStack.isEmpty()) {
            return;
        }
        float aw = this.w.getFloat((UnitVariables)event);
        float ah = this.h.getFloat((UnitVariables)event);
        float ax = event.alignX(this.x.getFloat((UnitVariables)event), aw, this.alignX);
        float ay = event.alignY(this.y.getFloat((UnitVariables)event), ah, this.alignY);
        float az = this.z.getFloat((UnitVariables)event);
        event.push();
        event.translate(ax, ay, az);
        if (this.rotation != FixedNumberUnit.ZERO) {
            event.rotateRad(this.rotation.getFloat((UnitVariables)event));
        }
        event.scale(aw / 16.0f, ah / 16.0f, 1.0f);
        event.blend(true);
        ItemObject.drawItem(event.matrices, this.itemStack, 0, this.overlay.getBoolean((UnitVariables)event), this.customText.isEmpty() ? null : this.customText);
        event.pop();
    }

    public static void drawItem(PoseStack poseStack, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        boolean flatLight;
        if (stack.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        ItemRenderer itemRenderer = mc.getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(stack, null, (LivingEntity)mc.player, hash);
        Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushPose();
        modelViewStack.mulPoseMatrix(poseStack.last().pose());
        modelViewStack.scale(1.0f, -1.0f, 1.0f);
        modelViewStack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flatLight = !bakedModel.usesBlockLight();
        if (flatLight) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        if (flatLight) {
            Lighting.setupFor3DItems();
        }
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
        if (renderOverlay) {
            float cooldown;
            Tesselator t = Tesselator.getInstance();
            Font font = mc.font;
            if (stack.getCount() != 1 || text != null) {
                String s = text == null ? String.valueOf(stack.getCount()) : text;
                poseStack.pushPose();
                poseStack.translate(9.0 - (double)font.width(s), 1.0, 20.0);
                font.drawInBatch(s, 0.0f, 0.0f, 0xFFFFFF, true, poseStack.last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                bufferSource.endBatch();
                poseStack.popPose();
            }
            if (stack.isBarVisible()) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                int barWidth = stack.getBarWidth();
                int barColor = stack.getBarColor();
                ItemObject.draw(poseStack, t, -6, 5, 13, 2, 0, 0, 0, 255);
                ItemObject.draw(poseStack, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
            }
            float f = cooldown = mc.player == null ? 0.0f : mc.player.getCooldowns().getCooldownPercent(stack.getItem(), mc.getFrameTime());
            if (cooldown > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                ItemObject.draw(poseStack, t, -8, Mth.floor((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.ceil((float)(16.0f * cooldown)), 255, 255, 255, 127);
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(PoseStack matrixStack, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width <= 0 || height <= 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f m = matrixStack.last().pose();
        BufferBuilder renderer = t.getBuilder();
        renderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        renderer.vertex(m, (float)x, (float)y, 0.0f).color(red, green, blue, alpha).endVertex();
        renderer.vertex(m, (float)x, (float)(y + height), 0.0f).color(red, green, blue, alpha).endVertex();
        renderer.vertex(m, (float)(x + width), (float)(y + height), 0.0f).color(red, green, blue, alpha).endVertex();
        renderer.vertex(m, (float)(x + width), (float)y, 0.0f).color(red, green, blue, alpha).endVertex();
        t.end();
    }
}

