/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.command;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.event.EventGroup;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.net.DisplayClientErrorsMessage;
import dev.latvian.mods.kubejs.net.DisplayServerErrorsMessage;
import dev.latvian.mods.kubejs.net.PaintMessage;
import dev.latvian.mods.kubejs.net.ReloadStartupScriptsMessage;
import dev.latvian.mods.kubejs.script.ConsoleLine;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.ExportablePackResources;
import dev.latvian.mods.kubejs.server.CustomCommandEventJS;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.apache.commons.io.FileUtils;

public class KubeJSCommands {
    private static final char UNICODE_TICK = '\u2714';
    private static final char UNICODE_CROSS = '\u2718';
    public static final DynamicCommandExceptionType NO_REGISTRY = new DynamicCommandExceptionType(id -> Component.literal((String)("No builtin or static registry found for " + id)));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        com.google.common.base.Predicate spOrOP = source -> source.getServer().isSingleplayer() || source.hasPermission(2);
        LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kubejs").then(Commands.literal((String)"help").executes(context -> KubeJSCommands.help((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"custom_command").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(ServerEvents.CUSTOM_COMMAND.findUniqueExtraIds(ScriptType.SERVER).stream().map(String::valueOf), (SuggestionsBuilder)builder)).executes(context -> KubeJSCommands.customCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(Commands.literal((String)"hand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).getPlayerOrException(), InteractionHand.MAIN_HAND)))).then(Commands.literal((String)"offhand").executes(context -> KubeJSCommands.hand(((CommandSourceStack)context.getSource()).getPlayerOrException(), InteractionHand.OFF_HAND)))).then(Commands.literal((String)"inventory").executes(context -> KubeJSCommands.inventory(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.literal((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"errors").then(((LiteralArgumentBuilder)Commands.literal((String)"startup").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.STARTUP)))).then(((LiteralArgumentBuilder)Commands.literal((String)"server").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.SERVER)))).then(((LiteralArgumentBuilder)Commands.literal((String)"client").requires(source -> true)).executes(context -> KubeJSCommands.errors((CommandSourceStack)context.getSource(), ScriptType.CLIENT))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").then(((LiteralArgumentBuilder)Commands.literal((String)"config").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadConfig((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"startup_scripts").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadStartup((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"server_scripts").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.reloadServer((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"export").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.export((CommandSourceStack)context.getSource()))).then(Commands.literal((String)"pack_zips").executes(context -> KubeJSCommands.exportPacks((CommandSourceStack)context.getSource(), true)))).then(Commands.literal((String)"pack_folders").executes(context -> KubeJSCommands.exportPacks((CommandSourceStack)context.getSource(), false))))).then(Commands.literal((String)"list_tag").then(((RequiredArgumentBuilder)Commands.argument((String)"registry", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(entry -> entry.key().location().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.listTagsFor((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))).then(Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(KubeJSCommands.allTags((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")).map(TagKey::location).map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.tagObjects((CommandSourceStack)ctx.getSource(), TagKey.create(KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry"), (ResourceLocation)ResourceLocationArgument.getId((CommandContext)ctx, (String)"tag")))))))).then(Commands.literal((String)"dump_registry").then(Commands.argument((String)"registry", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(((CommandSourceStack)ctx.getSource()).registryAccess().registries().map(entry -> entry.key().location().toString()), (SuggestionsBuilder)builder)).executes(ctx -> KubeJSCommands.dumpRegistry((CommandSourceStack)ctx.getSource(), KubeJSCommands.registry((CommandContext<CommandSourceStack>)ctx, "registry")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stages").requires((Predicate)spOrOP)).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.literal((String)"clear").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> KubeJSCommands.clearStages((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player")))))).then(Commands.literal((String)"list").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).executes(context -> KubeJSCommands.listStages((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"painter").requires((Predicate)spOrOP)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"object", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> KubeJSCommands.painter((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"player"), CompoundTagArgument.getCompoundTag((CommandContext)context, (String)"object"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"generate_typings").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.generateTypings((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"packmode").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.packmode((CommandSourceStack)context.getSource(), ""))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.packmode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.literal((String)"dump_internals").then(((LiteralArgumentBuilder)Commands.literal((String)"events").requires((Predicate)spOrOP)).executes(context -> KubeJSCommands.dumpEvents((CommandSourceStack)context.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"persistent_data").requires((Predicate)spOrOP)).then(KubeJSCommands.addPersistentDataCommands(Commands.literal((String)"server"), ctx -> Set.of(((CommandSourceStack)ctx.getSource()).getServer())))).then(((LiteralArgumentBuilder)Commands.literal((String)"dimension").then(KubeJSCommands.addPersistentDataCommands(Commands.literal((String)"*"), ctx -> (Collection)((CommandSourceStack)ctx.getSource()).getServer().getAllLevels()))).then(KubeJSCommands.addPersistentDataCommands(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()), ctx -> Set.of(DimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))))).then(Commands.literal((String)"entity").then(KubeJSCommands.addPersistentDataCommands(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()), ctx -> EntityArgument.getEntities((CommandContext)ctx, (String)"entity"))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"kjs").redirect((CommandNode)cmd));
    }

    private static int dumpEvents(CommandSourceStack source) {
        Map<String, EventGroup> groups = EventGroup.getGroups();
        Path output = KubeJSPaths.LOCAL.resolve("event_groups");
        for (Map.Entry<String, EventGroup> entry : groups.entrySet()) {
            String groupName = entry.getKey();
            EventGroup group = entry.getValue();
            Path groupFolder = output.resolve(groupName);
            try {
                Files.createDirectories(groupFolder, new FileAttribute[0]);
                FileUtils.cleanDirectory((File)groupFolder.toFile());
            }
            catch (IOException e) {
                ConsoleJS.SERVER.error("Failed to create folder for event group " + groupName, e);
                source.sendFailure((Component)Component.literal((String)("Failed to create folder for event group " + groupName)));
                return 0;
            }
            for (Map.Entry<String, EventHandler> handlerEntry : group.getHandlers().entrySet()) {
                String handlerName = handlerEntry.getKey();
                EventHandler handler = handlerEntry.getValue();
                Path handlerFile = groupFolder.resolve(handlerName + ".md");
                String fullName = "%s.%s".formatted(groupName, handlerName);
                Class<? extends EventJS> eventType = handler.eventType.get();
                StringBuilder builder = new StringBuilder();
                builder.append("# ").append(fullName).append("\n\n");
                builder.append("## Basic info\n\n");
                builder.append("- Valid script types: ").append(handler.scriptTypePredicate.getValidTypes()).append("\n\n");
                builder.append("- Has result? ").append(handler.getHasResult() ? (char)'\u2714' : '\u2718').append("\n\n");
                builder.append("- Event class: ");
                if (eventType.getPackageName().startsWith("dev.latvian.mods.kubejs")) {
                    builder.append('[').append(UtilsJS.toMappedTypeString(eventType)).append(']').append('(').append("https://github.com/KubeJS-Mods/KubeJS/tree/").append(2004).append("/common/src/main/java/").append(eventType.getPackageName().replace('.', '/')).append('/').append(eventType.getSimpleName()).append(".java").append(')');
                } else {
                    builder.append(UtilsJS.toMappedTypeString(eventType)).append(" (third-party)");
                }
                builder.append("\n\n");
                Info classInfo = eventType.getAnnotation(Info.class);
                if (classInfo != null) {
                    builder.append("```\n").append(classInfo.value()).append("```");
                    builder.append("\n\n");
                }
                ScriptManager scriptManager = ScriptType.SERVER.manager.get();
                Context cx = scriptManager.context;
                JavaMembers members = JavaMembers.lookupClass((Context)cx, (Scriptable)scriptManager.topLevelScope, eventType, null, (boolean)false);
                boolean hasDocumentedMembers = false;
                StringBuilder documentedMembers = new StringBuilder("### Documented members:\n\n");
                builder.append("### Available fields:\n\n");
                builder.append("| Name | Type | Static? |\n");
                builder.append("| ---- | ---- | ------- |\n");
                for (JavaMembers.FieldInfo field : members.getAccessibleFields(cx, false)) {
                    if (field.field.getDeclaringClass() == Object.class) continue;
                    String typeName = UtilsJS.toMappedTypeString(field.field.getGenericType());
                    builder.append("| ").append(field.name).append(" | ").append(typeName).append(" | ");
                    builder.append(Modifier.isStatic(field.field.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = field.field.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- `").append(typeName).append(' ').append(field.name).append("`\n");
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n").append("Note: Even if no fields are listed above, some methods are still available as fields through *beans*.\n\n");
                builder.append("### Available methods:\n\n");
                builder.append("| Name | Parameters | Return type | Static? |\n");
                builder.append("| ---- | ---------- | ----------- | ------- |\n");
                for (JavaMembers.MethodInfo method : members.getAccessibleMethods(cx, false)) {
                    int i;
                    if (method.hidden || method.method.getDeclaringClass() == Object.class) continue;
                    builder.append("| ").append(method.name).append(" | ");
                    Type[] params = method.method.getGenericParameterTypes();
                    CharSequence[] paramTypes = new String[params.length];
                    for (int i2 = 0; i2 < params.length; ++i2) {
                        paramTypes[i2] = UtilsJS.toMappedTypeString(params[i2]);
                    }
                    builder.append(String.join((CharSequence)", ", paramTypes)).append(" | ");
                    String returnType = UtilsJS.toMappedTypeString(method.method.getGenericReturnType());
                    builder.append(" | ").append(returnType).append(" | ");
                    builder.append(Modifier.isStatic(method.method.getModifiers()) ? (char)'\u2714' : '\u2718').append(" |\n");
                    Info info = method.method.getAnnotation(Info.class);
                    if (info == null) continue;
                    hasDocumentedMembers = true;
                    documentedMembers.append("- ").append('`');
                    if (Modifier.isStatic(method.method.getModifiers())) {
                        documentedMembers.append("static ");
                    }
                    documentedMembers.append(returnType).append(' ').append(method.name).append('(');
                    Param[] namedParams = info.params();
                    String[] paramNames = new String[params.length];
                    CharSequence[] signature = new String[params.length];
                    for (i = 0; i < params.length; ++i) {
                        String name1;
                        Object name = "var" + i;
                        if (namedParams.length > i && !Strings.isNullOrEmpty((String)(name1 = namedParams[i].name()))) {
                            name = name1;
                        }
                        paramNames[i] = name;
                        signature[i] = (String)paramTypes[i] + " " + (String)name;
                    }
                    documentedMembers.append(String.join((CharSequence)", ", signature)).append(')').append('`').append("\n");
                    if (params.length > 0) {
                        documentedMembers.append("\n  Parameters:\n");
                        for (i = 0; i < params.length; ++i) {
                            documentedMembers.append("  - ").append(paramNames[i]).append(": ").append((String)paramTypes[i]).append((String)(namedParams.length > i ? "- " + namedParams[i].value() : "")).append("\n");
                        }
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n");
                    String desc = info.value();
                    documentedMembers.append(desc);
                    if (!desc.endsWith("\n")) {
                        documentedMembers.append("\n");
                    }
                    documentedMembers.append("```\n\n");
                }
                builder.append("\n\n");
                if (hasDocumentedMembers) {
                    builder.append((CharSequence)documentedMembers).append("\n\n");
                }
                builder.append("### Example script:\n\n");
                builder.append("```js\n");
                builder.append(fullName).append('(');
                if (handler.extra != null) {
                    builder.append(handler.extra.required ? "extra_id, " : "/* extra_id (optional), */ ");
                }
                builder.append("(event) => {\n");
                builder.append("\t// This space (un)intentionally left blank\n");
                builder.append("});\n");
                builder.append("```\n\n");
                try {
                    Files.writeString(handlerFile, (CharSequence)builder.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    ConsoleJS.SERVER.error("Failed to write file for event handler " + fullName, e);
                    source.sendFailure((Component)Component.literal((String)("Failed to write file for event handler " + fullName)));
                    return 0;
                }
            }
        }
        source.sendSystemMessage((Component)Component.literal((String)("Successfully dumped event groups to " + output)));
        return 1;
    }

    private static <T> ResourceKey<Registry<T>> registry(CommandContext<CommandSourceStack> ctx, String arg) {
        return ResourceKey.createRegistryKey((ResourceLocation)ResourceLocationArgument.getId(ctx, (String)arg));
    }

    private static <T> Stream<TagKey<T>> allTags(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        return ((Registry)source.registryAccess().registry(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.location()))).getTagNames();
    }

    private static Component copy(String s, ChatFormatting col, String info) {
        return KubeJSCommands.copy((Component)Component.literal((String)s).withStyle(col), info);
    }

    private static Component copy(Component c, String info) {
        return Component.literal((String)"- ").withStyle(ChatFormatting.GRAY).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, c.getString()))).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)(info + " (Click to copy)"))))).append(c);
    }

    private static void link(CommandSourceStack source, ChatFormatting color, String name, String url) {
        source.sendSystemMessage((Component)Component.literal((String)"\u2022 ").append((Component)Component.literal((String)name).withStyle(color).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))));
    }

    private static int help(CommandSourceStack source) {
        KubeJSCommands.link(source, ChatFormatting.GOLD, "Wiki", "https://kubejs.com/?" + KubeJS.QUERY);
        KubeJSCommands.link(source, ChatFormatting.GREEN, "Support", "https://kubejs.com/support?" + KubeJS.QUERY);
        KubeJSCommands.link(source, ChatFormatting.BLUE, "Changelog", "https://kubejs.com/changelog?" + KubeJS.QUERY);
        return 1;
    }

    private static int customCommand(CommandSourceStack source, String id) {
        if (ServerEvents.CUSTOM_COMMAND.hasListeners()) {
            EventResult result = ServerEvents.CUSTOM_COMMAND.post(new CustomCommandEventJS((Level)source.getLevel(), source.getEntity(), BlockPos.containing((Position)source.getPosition()), id), id);
            if (result.type() == EventResult.Type.ERROR) {
                source.sendFailure((Component)Component.literal((String)result.value().toString()));
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private static int hand(ServerPlayer player, InteractionHand hand) {
        Optional containedFluid;
        Integer size;
        String id;
        TagKey tag2;
        player.sendSystemMessage((Component)Component.literal((String)"Item in hand:"));
        ItemStack stack = player.getItemInHand(hand);
        Holder holder = stack.getItemHolder();
        player.sendSystemMessage(KubeJSCommands.copy(ItemStackJS.toItemString(stack), ChatFormatting.GREEN, "Item ID"));
        List itemTags = holder.tags().toList();
        for (TagKey tag2 : itemTags) {
            String id2 = "'#%s'".formatted(tag2.location());
            Integer size2 = BuiltInRegistries.ITEM.getTag(tag2).map(HolderSet::size).orElse(0);
            player.sendSystemMessage(KubeJSCommands.copy(id2, ChatFormatting.YELLOW, "Item Tag [" + size2 + " items]"));
        }
        player.sendSystemMessage(KubeJSCommands.copy("'@" + stack.kjs$getMod() + "'", ChatFormatting.AQUA, "Mod [" + IngredientHelper.get().mod(stack.kjs$getMod()).kjs$getStacks().size() + " items]"));
        tag2 = stack.getItem();
        if (tag2 instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)tag2;
            player.sendSystemMessage((Component)Component.literal((String)"Held block:"));
            Block block = blockItem.getBlock();
            Holder.Reference blockHolder = block.builtInRegistryHolder();
            player.sendSystemMessage(KubeJSCommands.copy(block.kjs$getId(), ChatFormatting.GREEN, "Block ID"));
            List blockTags = blockHolder.tags().toList();
            for (TagKey tag3 : blockTags) {
                id = "'#%s'".formatted(tag3.location());
                size = BuiltInRegistries.BLOCK.getTag(tag3).map(HolderSet::size).orElse(0);
                player.sendSystemMessage(KubeJSCommands.copy(id, ChatFormatting.YELLOW, "Block Tag [" + size + " items]"));
            }
        }
        if ((containedFluid = FluidUtil.getFluidContained((ItemStack)stack)).isPresent()) {
            player.sendSystemMessage((Component)Component.literal((String)"Held fluid:"));
            FluidStack fluid = (FluidStack)containedFluid.orElseThrow();
            Holder.Reference fluidHolder = fluid.getFluid().builtInRegistryHolder();
            player.sendSystemMessage(KubeJSCommands.copy(fluidHolder.key().location().toString(), ChatFormatting.GREEN, "Fluid ID"));
            List fluidTags = fluidHolder.tags().toList();
            for (TagKey tag3 : fluidTags) {
                id = "'#%s'".formatted(tag3.location());
                size = BuiltInRegistries.FLUID.getTag(tag3).map(HolderSet::size).orElse(0);
                player.sendSystemMessage(KubeJSCommands.copy(id, ChatFormatting.YELLOW, "Fluid Tag [" + size + " items]"));
            }
        }
        return 1;
    }

    private static int inventory(ServerPlayer player) {
        return KubeJSCommands.dump((List<ItemStack>)player.getInventory().items, player, "Inventory");
    }

    private static int hotbar(ServerPlayer player) {
        return KubeJSCommands.dump(player.getInventory().items.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<ItemStack> stacks, ServerPlayer player, String name) {
        List<String> dump = stacks.stream().filter(is -> !is.isEmpty()).map(ItemStackJS::toItemString).toList();
        player.sendSystemMessage(KubeJSCommands.copy(dump.toString(), ChatFormatting.WHITE, name + " Item List"));
        return 1;
    }

    private static int errors(CommandSourceStack source, ScriptType type) throws CommandSyntaxException {
        if (type == ScriptType.CLIENT) {
            ServerPlayer player = source.getPlayerOrException();
            new DisplayClientErrorsMessage().sendTo(player);
            return 1;
        }
        if (type.console.errors.isEmpty() && type.console.warnings.isEmpty()) {
            source.sendSystemMessage((Component)Component.literal((String)"No errors or warnings found!").withStyle(ChatFormatting.GREEN));
            return 0;
        }
        if (source.getServer().isSingleplayer()) {
            KubeJS.PROXY.openErrors(type);
            return 1;
        }
        ServerPlayer player = source.getPlayerOrException();
        ArrayList<ConsoleLine> errors = new ArrayList<ConsoleLine>(type.console.errors);
        ArrayList<ConsoleLine> warnings = new ArrayList<ConsoleLine>(type.console.warnings);
        player.sendSystemMessage((Component)Component.literal((String)"You need KubeJS on client side!").withStyle(ChatFormatting.RED), true);
        new DisplayServerErrorsMessage(type, errors, warnings).sendTo(player);
        return 1;
    }

    private static int reloadConfig(CommandSourceStack source) {
        KubeJS.PROXY.reloadConfig();
        source.sendSystemMessage((Component)Component.literal((String)"Done!"));
        return 1;
    }

    private static int reloadStartup(CommandSourceStack source) {
        KubeJS.getStartupScriptManager().reload(null);
        source.sendSystemMessage((Component)Component.literal((String)"Done!"));
        new ReloadStartupScriptsMessage(source.getServer().isDedicatedServer()).sendToAll(source.getServer());
        return 1;
    }

    private static int reloadServer(CommandSourceStack source) {
        ServerScriptManager.instance.reload((ResourceManager)source.getServer().kjs$getReloadableResources().resourceManager());
        source.sendSuccess(() -> Component.literal((String)"Done! To reload recipes, tags, loot tables and other datapack things, run ").append((Component)Component.literal((String)"'/reload'").kjs$clickRunCommand("/reload").kjs$hover((Component)Component.literal((String)"Click to run"))), false);
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        KubeJS.PROXY.reloadClientInternal();
        source.sendSystemMessage((Component)Component.literal((String)"Done! To reload textures, models and other assets, press F3 + T"));
        return 1;
    }

    private static int reloadTextures(CommandSourceStack source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(CommandSourceStack source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(CommandSourceStack source) {
        if (DataExport.export != null) {
            return 0;
        }
        DataExport.export = new DataExport();
        DataExport.export.source = source;
        source.sendSuccess(() -> Component.literal((String)"Reloading server and exporting data..."), true);
        source.getServer().kjs$runCommand("reload");
        return 1;
    }

    private static void afterReload(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"Reloaded!"), true);
    }

    private static int exportPacks(CommandSourceStack source, boolean exportZip) {
        ArrayList<ExportablePackResources> packs = new ArrayList<ExportablePackResources>();
        for (Object pack : source.getServer().getResourceManager().listPacks().toList()) {
            if (!(pack instanceof ExportablePackResources)) continue;
            ExportablePackResources e = (ExportablePackResources)pack;
            packs.add(e);
        }
        KubeJS.PROXY.export(packs);
        int success = 0;
        for (ExportablePackResources pack : packs) {
            try {
                if (exportZip) {
                    path = KubeJSPaths.EXPORTED_PACKS.resolve(pack.packId() + ".zip");
                    Files.deleteIfExists(path);
                    try (FileSystem fs = FileSystems.newFileSystem(path, Map.of("create", true));){
                        pack.export(fs.getPath(".", new String[0]));
                    }
                } else {
                    path = KubeJSPaths.EXPORTED_PACKS.resolve(pack.packId());
                    if (Files.exists(path, new LinkOption[0])) {
                        Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    Files.createDirectories(path, new FileAttribute[0]);
                    pack.export(path);
                }
                source.sendSuccess(() -> Component.literal((String)"Successfully exported ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)pack.packId()).withStyle(ChatFormatting.BLUE)), false);
                ++success;
            }
            catch (IOException e) {
                e.printStackTrace();
                source.sendFailure((Component)Component.literal((String)"Failed to export %s!".formatted(pack)).withStyle(style -> style.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)e.getMessage())))));
            }
        }
        int success1 = success;
        if (source.getServer().isSingleplayer() && !source.getServer().isPublished()) {
            source.sendSuccess(() -> Component.literal((String)("Exported " + success1 + " packs")).kjs$clickOpenFile(KubeJSPaths.EXPORTED_PACKS.toAbsolutePath().toString()), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)("Exported " + success1 + " packs")), false);
        }
        return success;
    }

    private static int outputRecipes(ServerPlayer player) {
        player.sendSystemMessage((Component)Component.literal((String)"WIP!"));
        return 1;
    }

    private static int inputRecipes(ServerPlayer player) {
        player.sendSystemMessage((Component)Component.literal((String)"WIP!"));
        return 1;
    }

    private static int checkRecipeConflicts(ServerPlayer player) {
        player.sendSystemMessage((Component)Component.literal((String)"WIP!"));
        return 1;
    }

    private static <T> int listTagsFor(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream<TagKey<TagKey>> tags = KubeJSCommands.allTags(source, registry);
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("List of all Tags for " + registry.location() + ":")));
        source.sendSystemMessage((Component)Component.empty());
        long size = tags.map(TagKey::location).map(tag -> Component.literal((String)"- %s".formatted(tag)).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kubejs list_tag %s %s".formatted(registry.location(), tag))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"[Show all entries for %s]".formatted(tag)))))).mapToLong(msg -> {
            source.sendSystemMessage((Component)msg);
            return 1L;
        }).sum();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)"Total: %d tags".formatted(size)));
        source.sendSystemMessage((Component)Component.literal((String)"(Click on any of the above tags to list their contents!)"));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }

    private static <T> int tagObjects(CommandSourceStack source, TagKey<T> key) throws CommandSyntaxException {
        Registry registry = (Registry)source.registryAccess().registry(key.registry()).orElseThrow(() -> NO_REGISTRY.create((Object)key.registry().location()));
        Optional tag = registry.getTag(key);
        if (tag.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"Tag not found or empty!"));
            return 0;
        }
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("Contents of #" + key.location() + " [" + key.registry().location() + "]:")));
        source.sendSystemMessage((Component)Component.empty());
        HolderSet.Named items = (HolderSet.Named)tag.get();
        for (Holder holder : items) {
            String id = (String)holder.unwrap().map(o -> o.location().toString(), o -> o + " (unknown ID)");
            source.sendSystemMessage((Component)Component.literal((String)("- " + id)));
        }
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("Total: " + items.size() + " elements")));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }

    private static <T> int dumpRegistry(CommandSourceStack source, ResourceKey<Registry<T>> registry) throws CommandSyntaxException {
        Stream ids = ((Registry)source.registryAccess().registry(registry).orElseThrow(() -> NO_REGISTRY.create((Object)registry.location()))).holders();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)("List of all entries for registry " + registry.location() + ":")));
        source.sendSystemMessage((Component)Component.empty());
        long size = ids.map(holder -> {
            ResourceLocation id = holder.key().location();
            return Component.literal((String)"- %s".formatted(id)).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"%s [%s]".formatted(holder.value(), holder.value().getClass().getName())))));
        }).mapToLong(msg -> {
            source.sendSystemMessage((Component)msg);
            return 1L;
        }).sum();
        source.sendSystemMessage((Component)Component.empty());
        source.sendSystemMessage((Component)Component.literal((String)"Total: %d entries".formatted(size)));
        source.sendSystemMessage((Component)Component.empty());
        return 1;
    }

    private static int addStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().add(stage)) continue;
            source.sendSuccess(() -> Component.literal((String)("Added '" + stage + "' stage for " + p.getScoreboardName())), true);
        }
        return 1;
    }

    private static int removeStage(CommandSourceStack source, Collection<ServerPlayer> players, String stage) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().remove(stage)) continue;
            source.sendSuccess(() -> Component.literal((String)("Removed '" + stage + "' stage for " + p.getScoreboardName())), true);
        }
        return 1;
    }

    private static int clearStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            if (!p.kjs$getStages().clear()) continue;
            source.sendSuccess(() -> Component.literal((String)("Cleared stages for " + p.getScoreboardName())), true);
        }
        return 1;
    }

    private static int listStages(CommandSourceStack source, Collection<ServerPlayer> players) {
        for (ServerPlayer p : players) {
            source.sendSystemMessage((Component)Component.literal((String)(p.getScoreboardName() + " stages:")));
            p.kjs$getStages().getAll().stream().sorted().forEach(s -> source.sendSystemMessage((Component)Component.literal((String)("- " + s))));
        }
        return 1;
    }

    private static int painter(CommandSourceStack source, Collection<ServerPlayer> players, CompoundTag object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }

    private static int generateTypings(CommandSourceStack source) {
        if (!source.getServer().isSingleplayer()) {
            source.sendFailure((Component)Component.literal((String)"You can only run this command in singleplayer!"));
            return 0;
        }
        KubeJS.PROXY.generateTypings(source);
        return 1;
    }

    private static int packmode(CommandSourceStack source, String packmode) {
        if (packmode.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)("Current packmode: " + CommonProperties.get().packMode)), false);
        } else {
            CommonProperties.get().setPackMode(packmode);
            source.sendSuccess(() -> Component.literal((String)("Set packmode to: " + packmode)), true);
        }
        return 1;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addPersistentDataCommands(ArgumentBuilder<CommandSourceStack, ?> cmd, PersistentDataFactory factory) {
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.literal((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                Component dataStr = NbtUtils.toPrettyComponent((Tag)withPersistentData.kjs$getPersistentData());
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(": ").append(dataStr), false);
            }
            return objects.size();
        }))).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                CompoundTag data = key.equals("*") ? withPersistentData.kjs$getPersistentData() : withPersistentData.kjs$getPersistentData().get(key);
                Component dataStr = data == null ? Component.literal((String)"null").withStyle(ChatFormatting.RED) : NbtUtils.toPrettyComponent((Tag)data);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(": ").append(dataStr), false);
            }
            return objects.size();
        })));
        cmd.then(Commands.literal((String)"merge").then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            CompoundTag tag = CompoundTagArgument.getCompoundTag((CommandContext)ctx, (String)"nbt");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().merge(tag);
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW).append(o.kjs$getDisplayName())).append(" updated"), false);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.literal((String)"*").executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().getAllKeys().removeIf(UtilsJS.ALWAYS_TRUE);
            }
            return objects.size();
        }))).then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().remove(key);
            }
            return objects.size();
        })));
        cmd.then(((LiteralArgumentBuilder)Commands.literal((String)"scoreboard").then(Commands.literal((String)"import").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"target", (ArgumentType)ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument((String)"objective", (ArgumentType)ObjectiveArgument.objective()).executes(ctx -> {
            Objective objective;
            ServerScoreboard scoreboard = ((CommandSourceStack)ctx.getSource()).getServer().getScoreboard();
            Collection<? extends WithPersistentData> objects = factory.getAll((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            ScoreHolder target = ScoreHolderArgument.getName((CommandContext)ctx, (String)"target");
            ReadOnlyScoreInfo info = scoreboard.getPlayerScoreInfo(target, objective = ObjectiveArgument.getObjective((CommandContext)ctx, (String)"objective"));
            int score = info != null ? info.value() : 0;
            for (WithPersistentData withPersistentData : objects) {
                withPersistentData.kjs$getPersistentData().putInt(key, score);
            }
            return objects.size();
        })))))).then(Commands.literal((String)"export").then(Commands.argument((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"targets", (ArgumentType)ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument((String)"objective", (ArgumentType)ObjectiveArgument.objective()).executes(ctx -> {
            ServerScoreboard scoreboard = ((CommandSourceStack)ctx.getSource()).getServer().getScoreboard();
            WithPersistentData object = factory.getOne((CommandContext<CommandSourceStack>)ctx);
            String key = StringArgumentType.getString((CommandContext)ctx, (String)"key");
            Collection targets = ScoreHolderArgument.getNames((CommandContext)ctx, (String)"targets");
            Objective objective = ObjectiveArgument.getObjective((CommandContext)ctx, (String)"objective");
            int score = object.kjs$getPersistentData().getInt(key);
            for (ScoreHolder target : targets) {
                scoreboard.getOrCreatePlayerScore(target, objective).set(score);
            }
            return 1;
        }))))));
        return cmd;
    }

    @FunctionalInterface
    private static interface PersistentDataFactory {
        public static final SimpleCommandExceptionType EMPTY_LIST = new SimpleCommandExceptionType((Message)Component.literal((String)"Expected at least one target"));

        public Collection<? extends WithPersistentData> apply(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        default public Collection<? extends WithPersistentData> getAll(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list;
        }

        default public WithPersistentData getOne(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
            Collection<? extends WithPersistentData> list = this.apply(ctx);
            if (list.isEmpty()) {
                throw EMPTY_LIST.create();
            }
            return list.iterator().next();
        }
    }
}

