/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.util.RemapForJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface ItemStackKJS
extends SpecialEquality,
NBTSerializable,
JsonSerializable,
IngredientSupplierKJS {
    default public ItemStack kjs$self() {
        return (ItemStack)this;
    }

    default public boolean specialEquals(Object o, boolean shallow) {
        if (o instanceof CharSequence) {
            return this.kjs$getId().equals(UtilsJS.getID(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.kjs$equalsIgnoringCount(s);
        }
        return this.kjs$equalsIgnoringCount(ItemStackJS.of(o));
    }

    default public boolean kjs$equalsIgnoringCount(ItemStack stack) {
        ItemStack self = this.kjs$self();
        if (self == stack) {
            return true;
        }
        if (self.isEmpty()) {
            return stack.isEmpty();
        }
        return ItemStack.isSameItemSameTags((ItemStack)self, (ItemStack)stack);
    }

    default public ResourceLocation kjs$getIdLocation() {
        return this.kjs$self().getItem().kjs$getIdLocation();
    }

    default public String kjs$getId() {
        return this.kjs$self().getItem().kjs$getId();
    }

    default public Collection<ResourceLocation> kjs$getTags() {
        return Tags.byItem(this.kjs$self().getItem()).map(TagKey::location).collect(Collectors.toSet());
    }

    default public boolean kjs$hasTag(ResourceLocation tag) {
        return this.kjs$self().is(Tags.item(tag));
    }

    default public boolean kjs$isBlock() {
        return this.kjs$self().getItem() instanceof BlockItem;
    }

    default public ItemStack kjs$withCount(int c) {
        if (c <= 0 || this.kjs$self().isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack is = this.kjs$self().copy();
        is.setCount(c);
        return is;
    }

    default public void kjs$removeTag() {
        this.kjs$self().setTag(null);
    }

    default public String kjs$getNbtString() {
        return String.valueOf(this.kjs$self().getTag());
    }

    default public ItemStack kjs$withNBT(CompoundTag nbt) {
        ItemStack is = this.kjs$self().copy();
        CompoundTag tag0 = is.getTag();
        if (tag0 == null) {
            is.setTag(nbt);
        } else {
            is.setTag(tag0.merge(nbt));
        }
        return is;
    }

    default public ItemStack kjs$withName(@Nullable Component displayName) {
        ItemStack is = this.kjs$self().copy();
        if (displayName != null) {
            is.setHoverName(displayName);
        } else {
            is.resetHoverName();
        }
        return is;
    }

    default public Map<String, Integer> kjs$getEnchantments() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry entry : EnchantmentHelper.getEnchantments((ItemStack)this.kjs$self()).entrySet()) {
            ResourceLocation id = RegistryInfo.ENCHANTMENT.getId((Enchantment)entry.getKey());
            if (id == null) continue;
            map.put(id.toString(), (Integer)entry.getValue());
        }
        return map;
    }

    default public boolean kjs$hasEnchantment(Enchantment enchantment, int level) {
        return EnchantmentHelper.getItemEnchantmentLevel((Enchantment)enchantment, (ItemStack)this.kjs$self()) >= level;
    }

    @RemapForJS(value="enchant")
    default public ItemStack kjs$enchantCopy(Map<?, ?> enchantments) {
        ItemStack is = this.kjs$self();
        for (Map.Entry<?, ?> entry : enchantments.entrySet()) {
            Object obj;
            Enchantment enchantment = RegistryInfo.ENCHANTMENT.getValue(UtilsJS.getMCID(null, entry.getKey()));
            if (enchantment == null || !((obj = entry.getValue()) instanceof Number)) continue;
            Number number = (Number)obj;
            is = is.kjs$enchantCopy(enchantment, number.intValue());
        }
        return is;
    }

    @RemapForJS(value="enchant")
    default public ItemStack kjs$enchantCopy(Enchantment enchantment, int level) {
        ItemStack is = this.kjs$self().copy();
        if (is.getItem() == Items.ENCHANTED_BOOK) {
            EnchantedBookItem.addEnchantment((ItemStack)is, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        } else {
            is.enchant(enchantment, level);
        }
        return is;
    }

    default public String kjs$getMod() {
        return this.kjs$self().getItem().kjs$getMod();
    }

    @Deprecated
    default public Ingredient kjs$ignoreNBT() {
        ConsoleJS console = ConsoleJS.getCurrent(ConsoleJS.SERVER);
        console.warn("You don't need to call .ignoreNBT() anymore, all item ingredients ignore NBT by default!");
        return this.kjs$self().getItem().kjs$asIngredient();
    }

    default public Ingredient kjs$weakNBT() {
        return IngredientHelper.get().weakNBT(this.kjs$self());
    }

    default public Ingredient kjs$strongNBT() {
        return IngredientHelper.get().strongNBT(this.kjs$self());
    }

    default public boolean kjs$areItemsEqual(ItemStack other) {
        return this.kjs$self().getItem() == other.getItem();
    }

    default public boolean kjs$isNBTEqual(ItemStack other) {
        if (this.kjs$self().hasTag() == other.hasTag()) {
            CompoundTag nbt = this.kjs$self().getTag();
            CompoundTag nbt2 = other.getTag();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    default public float kjs$getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.kjs$self().getDestroySpeed(block == null ? Blocks.AIR.defaultBlockState() : block.getBlockState());
    }

    default public float kjs$getHarvestSpeed() {
        return this.kjs$getHarvestSpeed(null);
    }

    @RemapForJS(value="toNBT")
    default public CompoundTag toNBTJS() {
        return this.kjs$self().save(new CompoundTag());
    }

    default public CompoundTag kjs$getTypeData() {
        return this.kjs$self().getItem().kjs$getTypeData();
    }

    default public String kjs$toItemString() {
        ItemStack is = this.kjs$self();
        StringBuilder builder = new StringBuilder();
        int count = is.getCount();
        boolean hasNbt = is.hasTag();
        if (count > 1 && !hasNbt) {
            builder.append('\'');
            builder.append(count);
            builder.append("x ");
            builder.append(this.kjs$getId());
            builder.append('\'');
        } else if (hasNbt) {
            CompoundTag t;
            builder.append("Item.of('");
            builder.append(is.kjs$getId());
            builder.append('\'');
            ArrayList<Pair> enchants = null;
            if (count > 1) {
                builder.append(", ");
                builder.append(count);
            }
            if ((t = is.getTag()) != null && !t.isEmpty()) {
                String key;
                String string = key = is.getItem() == Items.ENCHANTED_BOOK ? "StoredEnchantments" : "Enchantments";
                if (t.contains(key, 9)) {
                    ListTag l = t.getList(key, 10);
                    enchants = new ArrayList<Pair>(l.size());
                    for (int i = 0; i < l.size(); ++i) {
                        CompoundTag t1 = l.getCompound(i);
                        enchants.add(Pair.of((Object)t1.getString("id"), (Object)t1.getInt("lvl")));
                    }
                    t = t.copy();
                    t.remove(key);
                    if (t.isEmpty()) {
                        t = null;
                    }
                }
            }
            if (t != null) {
                builder.append(", ");
                NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)t.toString());
            }
            builder.append(')');
            if (enchants != null) {
                for (Pair e : enchants) {
                    builder.append(".enchant('");
                    builder.append((String)e.getKey());
                    builder.append("', ");
                    builder.append(e.getValue());
                    builder.append(')');
                }
            }
        } else {
            builder.append('\'');
            builder.append(this.kjs$getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    default public Ingredient kjs$asIngredient() {
        return this.kjs$self().getItem().kjs$asIngredient();
    }

    default public JsonObject toJsonJS() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.kjs$getId());
        json.addProperty("count", (Number)this.kjs$self().getCount());
        CompoundTag tag = this.kjs$self().getTag();
        if (tag != null) {
            json.addProperty("nbt", tag.toString());
        }
        return json;
    }

    default public OutputItem kjs$withChance(double chance) {
        return OutputItem.of(this.kjs$self(), chance);
    }

    default public ItemStack kjs$withLore(Component[] text) {
        ItemStack is = this.kjs$self().copy();
        if (text.length > 0) {
            CompoundTag tag = is.getOrCreateTag();
            CompoundTag display = tag.getCompound("display");
            ListTag lore = display.getList("Lore", 8);
            for (Component t : text) {
                lore.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)t)));
            }
            display.put("Lore", (Tag)lore);
            tag.put("display", (Tag)display);
        }
        return is;
    }
}

