/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.core.DataSenderKJS;
import dev.latvian.mods.kubejs.core.MinecraftEnvironmentKJS;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.core.PlayerSelector;
import dev.latvian.mods.kubejs.core.WithAttachedData;
import dev.latvian.mods.kubejs.core.WithPersistentData;
import dev.latvian.mods.kubejs.net.SendDataFromServerMessage;
import dev.latvian.mods.kubejs.player.AdvancementJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@RemapPrefixForJS(value="kjs$")
public interface MinecraftServerKJS
extends WithAttachedData<MinecraftServer>,
WithPersistentData,
DataSenderKJS,
MinecraftEnvironmentKJS {
    default public MinecraftServer kjs$self() {
        return (MinecraftServer)this;
    }

    public MinecraftServer.ReloadableResources kjs$getReloadableResources();

    public ServerLevel kjs$getOverworld();

    @Override
    default public Component kjs$getName() {
        return Component.literal((String)this.kjs$self().name());
    }

    @Override
    default public void kjs$tell(Component message) {
        this.kjs$self().sendSystemMessage(message);
        for (ServerPlayer player : this.kjs$self().getPlayerList().getPlayers()) {
            player.kjs$tell(message);
        }
    }

    @Override
    default public void kjs$setStatusMessage(Component message) {
        for (ServerPlayer player : this.kjs$self().getPlayerList().getPlayers()) {
            player.kjs$setStatusMessage(message);
        }
    }

    @Override
    default public void kjs$runCommand(String command) {
        this.kjs$self().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack(), command);
    }

    @Override
    default public void kjs$runCommandSilent(String command) {
        this.kjs$self().getCommands().performPrefixedCommand(this.kjs$self().createCommandSourceStack().withSuppressedOutput(), command);
    }

    default public ServerLevel kjs$getLevel(ResourceLocation dimension) {
        return this.kjs$self().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
    }

    @Nullable
    default public ServerPlayer kjs$getPlayer(PlayerSelector selector) {
        return selector.getPlayer(this.kjs$self());
    }

    default public EntityArrayList kjs$getPlayers() {
        return new EntityArrayList((Level)this.kjs$self().overworld(), this.kjs$self().getPlayerList().getPlayers());
    }

    default public EntityArrayList kjs$getEntities() {
        EntityArrayList list = new EntityArrayList((Level)this.kjs$self().overworld(), 10);
        for (ServerLevel level : this.kjs$self().getAllLevels()) {
            list.addAllIterable(level.getAllEntities());
        }
        return list;
    }

    @Nullable
    default public AdvancementJS kjs$getAdvancement(ResourceLocation id) {
        AdvancementNode a = this.kjs$self().getAdvancements().tree().get(id);
        return a == null ? null : new AdvancementJS(a);
    }

    @Override
    default public void kjs$sendData(String channel, @Nullable CompoundTag data) {
        new SendDataFromServerMessage(channel, data).sendToAll(this.kjs$self());
    }

    @HideFromJS
    default public void kjs$afterResourcesLoaded(boolean reload) {
        if (reload) {
            DataExport.exportData();
        }
        if (reload && CommonProperties.get().announceReload && !CommonProperties.get().hideServerScriptErrors) {
            if (ConsoleJS.SERVER.errors.isEmpty()) {
                this.kjs$tell((Component)Component.literal((String)"Reloaded with no KubeJS errors!").withStyle(ChatFormatting.GREEN));
            } else {
                this.kjs$tell(ConsoleJS.SERVER.errorsComponent("/kubejs errors server"));
            }
        }
        ConsoleJS.SERVER.setCapturingErrors(false);
        ConsoleJS.SERVER.info("Server resource reload complete!");
    }

    default public Map<UUID, Map<Integer, ItemStack>> kjs$restoreInventories() {
        throw new NoMixinException();
    }
}

