/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core.mixin.common;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootDataManager.class})
public abstract class LootTablesMixin {
    @Shadow
    private Map<LootDataId<?>, ?> elements;

    @Inject(method={"apply*(Ljava/util/Map;)V"}, at={@At(value="RETURN")})
    private void kjs$apply(Map<LootDataType<?>, Map<ResourceLocation, ?>> parsedMap, CallbackInfo ci) {
        if (DataExport.export != null) {
            for (Map.Entry<LootDataId<?>, ?> entry : this.elements.entrySet()) {
                LootDataType type = entry.getKey().type();
                ResourceLocation id = entry.getKey().location();
                try {
                    JsonElement lootJson = UtilsJS.toJsonOrThrow(UtilsJS.cast(entry.getValue()), type.codec);
                    String fileName = "%s/%s/%s.json".formatted(type.directory(), id.getNamespace(), id.getPath());
                    DataExport.export.addJson(fileName, lootJson);
                }
                catch (Exception ex) {
                    ConsoleJS.SERVER.error("Failed to export loot table %s as JSON!".formatted(id), ex);
                }
            }
        }
    }
}

