/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.latvian.mods.kubejs.entity.LivingEntityEventJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import org.jetbrains.annotations.Nullable;

public class LivingEntityDropsEventJS
extends LivingEntityEventJS {
    private final LivingDropsEvent event;
    public List<ItemEntity> eventDrops;

    public LivingEntityDropsEventJS(LivingDropsEvent e) {
        this.event = e;
    }

    @Override
    public LivingEntity getEntity() {
        return this.event.getEntity();
    }

    public DamageSource getSource() {
        return this.event.getSource();
    }

    public int getLootingLevel() {
        return this.event.getLootingLevel();
    }

    public boolean isRecentlyHit() {
        return this.event.isRecentlyHit();
    }

    public List<ItemEntity> getDrops() {
        if (this.eventDrops == null) {
            this.eventDrops = new ArrayList<ItemEntity>(this.event.getDrops());
        }
        return this.eventDrops;
    }

    @Nullable
    public ItemEntity addDrop(ItemStack stack) {
        if (!stack.isEmpty()) {
            LivingEntity e = this.event.getEntity();
            ItemEntity ei = new ItemEntity(e.level(), e.getX(), e.getY(), e.getZ(), stack);
            ei.setPickUpDelay(10);
            this.getDrops().add(ei);
            return ei;
        }
        return null;
    }

    @Nullable
    public ItemEntity addDrop(ItemStack stack, float chance) {
        if (chance >= 1.0f || this.event.getEntity().level().random.nextFloat() <= chance) {
            return this.addDrop(stack);
        }
        return null;
    }
}

