/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.helpers;

import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.ingredient.CreativeTabIngredient;
import dev.latvian.mods.kubejs.recipe.ingredient.ModIngredient;
import dev.latvian.mods.kubejs.recipe.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.recipe.ingredient.WildcardIngredient;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.crafting.IntersectionIngredient;
import net.neoforged.neoforge.common.crafting.NBTIngredient;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public enum IngredientHelper {
    INSTANCE;

    public static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPES;
    public static final Supplier<IngredientType<WildcardIngredient>> WILDCARD;
    public static final Supplier<IngredientType<ModIngredient>> MOD;
    public static final Supplier<IngredientType<RegExIngredient>> REGEX;
    public static final Supplier<IngredientType<CreativeTabIngredient>> CREATIVE_TAB;

    public static IngredientHelper get() {
        return INSTANCE;
    }

    public InputItem stack(Ingredient ingredient, int count) {
        return InputItem.of(ingredient, count);
    }

    public static void register(IEventBus bus) {
        INGREDIENT_TYPES.register(bus);
    }

    public Ingredient wildcard() {
        return WildcardIngredient.INSTANCE;
    }

    public Ingredient tag(String tag) {
        return Ingredient.of(Tags.item(UtilsJS.getMCID(null, tag)));
    }

    public Ingredient mod(String mod) {
        return new ModIngredient(mod);
    }

    public Ingredient regex(Pattern pattern) {
        return new RegExIngredient(pattern);
    }

    public Ingredient creativeTab(CreativeModeTab tab) {
        return new CreativeTabIngredient(tab);
    }

    public Ingredient subtract(Ingredient base, Ingredient subtracted) {
        return DifferenceIngredient.of((Ingredient)base, (Ingredient)subtracted);
    }

    public Ingredient or(Ingredient[] ingredients) {
        return ingredients.length == 0 ? Ingredient.EMPTY : CompoundIngredient.of((Ingredient[])ingredients);
    }

    public Ingredient and(Ingredient[] ingredients) {
        return ingredients.length == 0 ? Ingredient.EMPTY : (ingredients.length == 1 ? ingredients[0] : IntersectionIngredient.of((Ingredient[])ingredients));
    }

    public Ingredient strongNBT(ItemStack item) {
        return NBTIngredient.of((boolean)true, (ItemStack)item.copy());
    }

    public Ingredient weakNBT(ItemStack item) {
        return item.hasTag() ? NBTIngredient.of((boolean)false, (ItemStack)item.copy()) : item.kjs$asIngredient();
    }

    public boolean isWildcard(Ingredient ingredient) {
        return ingredient == WildcardIngredient.INSTANCE;
    }

    static {
        INGREDIENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.INGREDIENT_TYPES, (String)"kubejs");
        WILDCARD = INGREDIENT_TYPES.register("wildcard", () -> new IngredientType(WildcardIngredient.CODEC));
        MOD = INGREDIENT_TYPES.register("mod", () -> new IngredientType(ModIngredient.CODEC));
        REGEX = INGREDIENT_TYPES.register("regex", () -> new IngredientType(RegExIngredient.CODEC));
        CREATIVE_TAB = INGREDIENT_TYPES.register("creative_tab", () -> new IngredientType(CreativeTabIngredient.CODEC));
    }
}

