/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.helpers;

import dev.latvian.mods.kubejs.gui.KubeJSMenu;
import dev.latvian.mods.kubejs.script.PlatformWrapper;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforgespi.language.IModInfo;

public enum MiscHelper {
    INSTANCE;


    public static MiscHelper get() {
        return INSTANCE;
    }

    public void setModName(PlatformWrapper.ModInfo info, String name) {
        try {
            IModInfo iModInfo;
            Optional mc = ModList.get().getModContainerById(info.getId());
            if (mc.isPresent() && (iModInfo = ((ModContainer)mc.get()).getModInfo()) instanceof ModInfo) {
                ModInfo i = (ModInfo)iModInfo;
                Field field = ModInfo.class.getDeclaredField("displayName");
                field.setAccessible(true);
                field.set(i, name);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isDataGen() {
        return FMLLoader.getLaunchHandler().isData();
    }

    public long ingotFluidAmount() {
        return 90L;
    }

    public long bottleFluidAmount() {
        return 250L;
    }

    public CreativeModeTab creativeModeTab(Component name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator content) {
        return CreativeModeTab.builder().title(name).icon(icon).displayItems(content).build();
    }

    public MenuType<KubeJSMenu> createMenuType() {
        return new MenuType((MenuType.MenuSupplier)((IContainerFactory)KubeJSMenu::new), FeatureFlags.VANILLA_SET);
    }
}

