/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.helpers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public enum RecipeHelper {
    INSTANCE;


    public static RecipeHelper get() {
        return INSTANCE;
    }

    @Nullable
    public RecipeHolder<?> fromJson(RecipeSerializer<?> serializer, ResourceLocation id, JsonObject json) {
        return RecipeManager.fromJson((ResourceLocation)id, (JsonObject)json, (DynamicOps)JsonOps.INSTANCE).orElse(null);
    }

    public DataResult<JsonObject> validate(JsonElement jsonElement) {
        if (!jsonElement.isJsonObject()) {
            return DataResult.error(() -> "not a json object: " + jsonElement);
        }
        JsonObject json = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"top element");
        ICondition.IContext context = KubeJSReloadListener.resources.getConditionContext();
        RegistryAccess registry = KubeJSReloadListener.resources.getRegistryAccess();
        if (!json.has("type")) {
            return DataResult.error(() -> "missing type");
        }
        ConditionalOps ops = new ConditionalOps(RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registry), context);
        Codec codec = ConditionalOps.createConditionalCodec((Codec)Codec.unit((Object)json));
        return codec.parse((DynamicOps)ops, (Object)json).mapError(str -> "error while parsing conditions: " + str).flatMap(optional -> optional.map(DataResult::success).orElseGet(() -> DataResult.error(() -> "conditions not met")));
    }

    public Ingredient getCustomIngredient(JsonObject object) {
        return Ingredient.fromJson((JsonElement)object, (boolean)false);
    }
}

