/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.helpers.LevelHelper;
import dev.latvian.mods.kubejs.item.PlayerMainInvWrapper;
import java.util.Objects;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerUtils {
    public static void giveItemToPlayer(Player player, @NotNull ItemStack stack, int preferredSlot) {
        if (stack.isEmpty()) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.getInventory());
        Level level = player.level();
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.kjs$getSlots()) {
            remainder = inventory.kjs$insertItem(preferredSlot, stack, false);
        }
        if (!remainder.isEmpty()) {
            remainder = ItemHandlerUtils.insertItemStacked(inventory, remainder, false);
        }
        if (remainder.isEmpty() || remainder.getCount() != stack.getCount()) {
            level.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.isEmpty() && !level.isClientSide) {
            ItemEntity itemEntity = new ItemEntity(level, player.getX(), player.getY() + 0.5, player.getZ(), remainder);
            itemEntity.setPickUpDelay(40);
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    @NotNull
    public static ItemStack insertItemStacked(InventoryKJS inventory, @NotNull ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || stack.isEmpty()) {
            return stack;
        }
        if (!stack.isStackable()) {
            return ItemHandlerUtils.insertItem(inventory, stack, simulate);
        }
        int sizeInventory = inventory.kjs$getSlots();
        for (i = 0; !(i >= sizeInventory || ItemHandlerUtils.canItemStacksStackRelaxed(slot = inventory.kjs$getStackInSlot(i), stack) && (stack = inventory.kjs$insertItem(i, stack, simulate)).isEmpty()); ++i) {
        }
        if (!stack.isEmpty()) {
            for (i = 0; !(i >= sizeInventory || inventory.kjs$getStackInSlot(i).isEmpty() && (stack = inventory.kjs$insertItem(i, stack, simulate)).isEmpty()); ++i) {
            }
        }
        return stack;
    }

    @NotNull
    public static ItemStack insertItem(InventoryKJS dest, @NotNull ItemStack stack, boolean simulate) {
        if (dest == null || stack.isEmpty()) {
            return stack;
        }
        for (int i = 0; i < dest.kjs$getSlots(); ++i) {
            if (!(stack = dest.kjs$insertItem(i, stack, simulate)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@NotNull ItemStack a, @NotNull ItemStack b) {
        if (a.isEmpty() || b.isEmpty() || a.getItem() != b.getItem()) {
            return false;
        }
        if (!a.isStackable()) {
            return false;
        }
        if (a.hasTag() != b.hasTag()) {
            return false;
        }
        if (!a.hasTag() || Objects.equals(a.getTag(), b.getTag())) {
            return LevelHelper.get().isDataCompatible(a, b);
        }
        return false;
    }

    public static boolean canItemStacksStack(@NotNull ItemStack a, @NotNull ItemStack b) {
        if (a.isEmpty() || !ItemStack.isSameItem((ItemStack)a, (ItemStack)b) || a.hasTag() != b.hasTag()) {
            return false;
        }
        if (!a.hasTag() || Objects.equals(a.getTag(), b.getTag())) {
            return LevelHelper.get().isDataCompatible(a, b);
        }
        return false;
    }
}

