/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface ItemStackJS {
    public static final Map<String, ItemStack> PARSE_CACHE = new HashMap<String, ItemStack>();
    public static final ItemStack[] EMPTY_ARRAY = new ItemStack[0];
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
        ArrayList<String> cachedItemTypeList = new ArrayList<String>();
        for (Map.Entry<ResourceKey<Item>, Item> entry : RegistryInfo.ITEM.entrySet()) {
            cachedItemTypeList.add(entry.getKey().location().toString());
        }
        return cachedItemTypeList;
    });
    public static final Lazy<Map<ResourceLocation, Collection<ItemStack>>> CACHED_ITEM_MAP = Lazy.of(() -> {
        HashMap<ResourceLocation, Collection> map = new HashMap<ResourceLocation, Collection>();
        Set stackList = ItemStackLinkedSet.createTypeAndTagSet();
        stackList.addAll(CreativeModeTabs.searchTab().getDisplayItems());
        for (ItemStack stack : stackList) {
            if (stack.isEmpty()) continue;
            map.computeIfAbsent(stack.getItem().kjs$getIdLocation(), _rl -> ItemStackLinkedSet.createTypeAndTagSet()).add(stack.kjs$withCount(1));
        }
        for (String itemId : CACHED_ITEM_TYPE_LIST.get()) {
            ResourceLocation itemRl = new ResourceLocation(itemId);
            map.computeIfAbsent(itemRl, id -> Set.of(RegistryInfo.ITEM.getValue((ResourceLocation)id).getDefaultInstance()));
        }
        return map;
    });
    public static final Lazy<List<ItemStack>> CACHED_ITEM_LIST = Lazy.of(() -> CACHED_ITEM_MAP.get().values().stream().flatMap(Collection::stream).toList());

    public static ItemStack of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR) {
            return ItemStack.EMPTY;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.isEmpty() ? ItemStack.EMPTY : stack;
        }
        if (o instanceof OutputItem) {
            OutputItem out = (OutputItem)o;
            return out.item;
        }
        if (o instanceof Ingredient) {
            Ingredient ingr = (Ingredient)o;
            return ingr.kjs$getFirst();
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            Item item = RegistryInfo.ITEM.getValue(id);
            if (item == null || item == Items.AIR) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                }
                return ItemStack.EMPTY;
            }
            return item.getDefaultInstance();
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return new ItemStack((ItemLike)itemLike.asItem());
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(json);
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return ItemStackJS.of(tag.getAsString());
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return IngredientHelper.get().regex(reg).kjs$getFirst();
            }
            return ItemStack.EMPTY;
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString().trim();
            ItemStack cached = PARSE_CACHE.get(os);
            if (cached != null) {
                return cached.isEmpty() ? ItemStack.EMPTY : cached.copy();
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            cached = ItemStackJS.parse(s);
            cached.setCount(count);
            PARSE_CACHE.put(os, cached);
            return cached.copy();
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                ResourceLocation id = UtilsJS.getMCID(null, map.get("item").toString());
                Item item = RegistryInfo.ITEM.getValue(id);
                if (item == Items.AIR) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return ItemStack.EMPTY;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                Object obj = map.get("count");
                if (obj instanceof Number) {
                    Number number = (Number)obj;
                    stack.setCount(number.intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.setTag(NBTUtils.toTagCompound(map.get("nbt")));
                }
                return stack;
            }
            Object id = map.get("tag");
            if (id instanceof CharSequence) {
                CharSequence s = (CharSequence)id;
                ItemStack stack = IngredientHelper.get().tag(s.toString()).kjs$getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack parse(String s) {
        String tagStr;
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return ItemStack.EMPTY;
        }
        if (s.startsWith("#")) {
            return IngredientHelper.get().tag(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("@")) {
            return IngredientHelper.get().mod(s.substring(1)).kjs$getFirst();
        }
        if (s.startsWith("%")) {
            CreativeModeTab group = UtilsJS.findCreativeTab(new ResourceLocation(s.substring(1)));
            if (group == null) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                }
                return ItemStack.EMPTY;
            }
            return IngredientHelper.get().creativeTab(group).kjs$getFirst();
        }
        Pattern reg = UtilsJS.parseRegex(s);
        if (reg != null) {
            return IngredientHelper.get().regex(reg).kjs$getFirst();
        }
        int spaceIndex = s.indexOf(32);
        String id = spaceIndex == -1 ? s : s.substring(0, spaceIndex);
        Item item = RegistryInfo.ITEM.getValue(new ResourceLocation(id));
        if (item == Items.AIR) {
            if (RecipeJS.itemErrors) {
                throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
            }
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (spaceIndex != -1 && (tagStr = s.substring(spaceIndex + 1)).length() >= 2 && tagStr.charAt(0) == '{') {
            stack.setTag(NBTUtils.toTagCompound((Object)tagStr));
        }
        return stack;
    }

    public static Item getRawItem(Context cx, @Nullable Object o) {
        if (o == null) {
            return Items.AIR;
        }
        if (o instanceof ItemLike) {
            ItemLike item = (ItemLike)o;
            return item.asItem();
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return Items.AIR;
            }
            if (s.charAt(0) != '#') {
                return RegistryInfo.ITEM.getValue(UtilsJS.getMCID(cx, s));
            }
        }
        return ItemStackJS.of(o).getItem();
    }

    public static ItemStack resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ItemStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)json;
            ItemStack stack = null;
            if (jsonObj.has("item")) {
                stack = ItemStackJS.of(jsonObj.get("item").getAsString());
            } else if (jsonObj.has("tag")) {
                stack = IngredientHelper.get().tag(jsonObj.get("tag").getAsString()).kjs$getFirst();
            }
            if (stack != null) {
                if (jsonObj.has("count")) {
                    stack.setCount(jsonObj.get("count").getAsInt());
                } else if (jsonObj.has("amount")) {
                    stack.setCount(jsonObj.get("amount").getAsInt());
                }
                if (jsonObj.has("nbt")) {
                    JsonElement element = jsonObj.get("nbt");
                    if (element.isJsonObject()) {
                        stack.setTag(NBTUtils.toTagCompound((Object)element));
                    } else {
                        stack.setTag(NBTUtils.toTagCompound((Object)element.getAsString()));
                    }
                }
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static String toItemString(Object object) {
        return ItemStackJS.of(object).kjs$toItemString();
    }

    public static List<ItemStack> getList() {
        return CACHED_ITEM_LIST.get();
    }

    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static Map<ResourceLocation, Collection<ItemStack>> getTypeToStacks() {
        return CACHED_ITEM_MAP.get();
    }

    public static void clearAllCaches() {
        CACHED_ITEM_LIST.forget();
        CACHED_ITEM_TYPE_LIST.forget();
        PARSE_CACHE.clear();
        InputItem.PARSE_CACHE.clear();
    }
}

