/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.misc;

import dev.latvian.mods.kubejs.misc.EnchantmentBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class BasicEnchantment
extends Enchantment {
    public final EnchantmentBuilder enchantmentBuilder;

    public BasicEnchantment(EnchantmentBuilder b) {
        super(b.rarity, b.category, b.slots);
        this.enchantmentBuilder = b;
    }

    public int getMinLevel() {
        return this.enchantmentBuilder.minLevel;
    }

    public int getMaxLevel() {
        return this.enchantmentBuilder.maxLevel;
    }

    public int getMinCost(int i) {
        if (this.enchantmentBuilder.minCost != null) {
            return this.enchantmentBuilder.minCost.get(i);
        }
        return super.getMinCost(i);
    }

    public int getMaxCost(int i) {
        if (this.enchantmentBuilder.maxCost != null) {
            return this.enchantmentBuilder.maxCost.get(i);
        }
        return super.getMaxCost(i);
    }

    public int getDamageProtection(int i, DamageSource damageSource) {
        if (this.enchantmentBuilder.damageProtection != null) {
            return this.enchantmentBuilder.damageProtection.getDamageProtection(i, damageSource);
        }
        return super.getDamageProtection(i, damageSource);
    }

    public float getDamageBonus(int i, MobType mobType) {
        if (this.enchantmentBuilder.damageBonus != null) {
            return this.enchantmentBuilder.damageBonus.getDamageBonus(i, UtilsJS.getMobTypeId(mobType));
        }
        return super.getDamageBonus(i, mobType);
    }

    protected boolean checkCompatibility(Enchantment enchantment) {
        if (enchantment == this) {
            return false;
        }
        if (this.enchantmentBuilder.checkCompatibility != null) {
            return (Boolean)this.enchantmentBuilder.checkCompatibility.apply((Object)RegistryInfo.ENCHANTMENT.getId(enchantment));
        }
        return true;
    }

    public boolean canEnchant(ItemStack itemStack) {
        if (super.canEnchant(itemStack)) {
            return true;
        }
        if (this.enchantmentBuilder.canEnchant != null) {
            return (Boolean)this.enchantmentBuilder.canEnchant.apply((Object)itemStack);
        }
        return false;
    }

    public void doPostAttack(LivingEntity entity, Entity target, int level) {
        if (this.enchantmentBuilder.postAttack != null) {
            this.enchantmentBuilder.postAttack.apply(entity, target, level);
        }
    }

    public void doPostHurt(LivingEntity entity, Entity target, int level) {
        if (this.enchantmentBuilder.postHurt != null) {
            this.enchantmentBuilder.postHurt.apply(entity, target, level);
        }
    }

    public boolean isTreasureOnly() {
        return this.enchantmentBuilder.treasureOnly;
    }

    public boolean isCurse() {
        return this.enchantmentBuilder.curse;
    }

    public boolean isTradeable() {
        return this.enchantmentBuilder.tradeable;
    }

    public boolean isDiscoverable() {
        return this.enchantmentBuilder.discoverable;
    }
}

