/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.misc;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.mod.util.color.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.jetbrains.annotations.NotNull;

public abstract class MobEffectBuilder
extends BuilderBase<MobEffect> {
    public transient MobEffectCategory category = MobEffectCategory.NEUTRAL;
    public transient EffectTickCallback effectTick = null;
    public transient Map<ResourceLocation, AttributeModifierTemplate> attributeModifiers = new HashMap<ResourceLocation, AttributeModifierTemplate>();
    public transient int color = 0xFFFFFF;
    public transient boolean instant;

    public MobEffectBuilder(ResourceLocation i) {
        super(i);
    }

    @Override
    public final RegistryInfo getRegistryType() {
        return RegistryInfo.MOB_EFFECT;
    }

    public MobEffectBuilder modifyAttribute(ResourceLocation attribute, String identifier, double d, AttributeModifier.Operation operation) {
        this.attributeModifiers.put(attribute, new MobEffectJSAttributeModifierTemplate(identifier, d, operation));
        return this;
    }

    public MobEffectBuilder category(MobEffectCategory c) {
        this.category = c;
        return this;
    }

    public MobEffectBuilder harmful() {
        return this.category(MobEffectCategory.HARMFUL);
    }

    public MobEffectBuilder beneficial() {
        return this.category(MobEffectCategory.BENEFICIAL);
    }

    public MobEffectBuilder effectTick(EffectTickCallback effectTick) {
        this.effectTick = effectTick;
        return this;
    }

    public MobEffectBuilder color(Color col) {
        this.color = col.getRgbJS();
        return this;
    }

    public MobEffectBuilder instant() {
        return this.instant(true);
    }

    public MobEffectBuilder instant(boolean instant) {
        this.instant = instant;
        return this;
    }

    @FunctionalInterface
    public static interface EffectTickCallback {
        public void applyEffectTick(LivingEntity var1, int var2);
    }

    static class MobEffectJSAttributeModifierTemplate
    implements AttributeModifierTemplate {
        private final UUID uuid;
        private final String id;
        private final double amount;
        private final AttributeModifier.Operation operation;

        public MobEffectJSAttributeModifierTemplate(String id, double amount, AttributeModifier.Operation operation) {
            this.id = id;
            this.amount = amount;
            this.operation = operation;
            this.uuid = new UUID(id.hashCode(), id.hashCode());
        }

        @NotNull
        public UUID getAttributeModifierId() {
            return this.uuid;
        }

        @NotNull
        public AttributeModifier create(int i) {
            return new AttributeModifier(this.uuid, this.id, this.amount, this.operation);
        }
    }
}

