/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.neoforge;

import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.event.EntityEvents;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.bindings.event.StartupEvents;
import dev.latvian.mods.kubejs.entity.LivingEntityDropsEventJS;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.item.ItemDestroyedEventJS;
import dev.latvian.mods.kubejs.item.creativetab.CreativeTabCallback;
import dev.latvian.mods.kubejs.item.creativetab.CreativeTabEvent;
import dev.latvian.mods.kubejs.item.creativetab.KubeJSCreativeTabs;
import dev.latvian.mods.kubejs.neoforge.KubeJSNeoForgeClient;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="kubejs")
public class KubeJSEntryPoint {
    private static final ThreadLocal<IEventBus> BUS = new ThreadLocal();

    public KubeJSEntryPoint(IEventBus bus) throws Throwable {
        bus.addListener(EventPriority.LOW, KubeJSEntryPoint::loadComplete);
        bus.addListener(EventPriority.LOW, KubeJSEntryPoint::initRegistries);
        bus.addListener(EventPriority.LOW, KubeJSEntryPoint::commonSetup);
        bus.addListener(EventPriority.LOW, KubeJSEntryPoint::creativeTab);
        BUS.set(bus);
        KubeJS.instance = new KubeJS();
        KubeJS.instance.setup();
        if (CommonProperties.get().serverOnly) {
            ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        }
        NeoForge.EVENT_BUS.addListener(KubeJSEntryPoint::itemDestroyed);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, KubeJSEntryPoint::livingDrops);
        if (!CommonProperties.get().serverOnly) {
            NeoForgeMod.enableMilkFluid();
            IngredientHelper.register(bus);
            KubeJSCreativeTabs.init();
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            new KubeJSNeoForgeClient();
        }
    }

    private static void initRegistries(RegisterEvent event) {
        RegistryInfo<?> info = RegistryInfo.of(event.getRegistryKey());
        info.registerObjects((id, supplier) -> event.register((ResourceKey)UtilsJS.cast(info.key), id, supplier));
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
    }

    private static void creativeTab(BuildCreativeModeTabContentsEvent event) {
        ResourceLocation tabId = event.getTabKey().location();
        if (StartupEvents.MODIFY_CREATIVE_TAB.hasListeners(tabId)) {
            StartupEvents.MODIFY_CREATIVE_TAB.post((ScriptTypeHolder)ScriptType.STARTUP, (Object)tabId, new CreativeTabEvent(event.getTab(), event.hasPermissions(), new CreativeTabCallbackForge(event)));
        }
    }

    private static void loadComplete(FMLLoadCompleteEvent event) {
        KubeJS.instance.loadComplete();
    }

    private static void itemDestroyed(PlayerDestroyItemEvent event) {
        if (ItemEvents.ITEM_DESTROYED.hasListeners()) {
            ItemEvents.ITEM_DESTROYED.post((ScriptTypeHolder)event.getEntity(), (Object)event.getOriginal().getItem(), new ItemDestroyedEventJS(event));
        }
    }

    private static void livingDrops(LivingDropsEvent event) {
        if (EntityEvents.ENTITY_DROPS.hasListeners()) {
            LivingEntityDropsEventJS e = new LivingEntityDropsEventJS(event);
            if (EntityEvents.ENTITY_DROPS.post((ScriptTypeHolder)event.getEntity(), (Object)e.getEntity().getType(), e).interruptFalse()) {
                event.setCanceled(true);
            } else if (e.eventDrops != null) {
                event.getDrops().clear();
                event.getDrops().addAll(e.eventDrops);
            }
        }
    }

    public static Optional<IEventBus> eventBus() {
        return Optional.ofNullable(BUS.get());
    }

    private record CreativeTabCallbackForge(BuildCreativeModeTabContentsEvent event) implements CreativeTabCallback
    {
        @Override
        public void addAfter(ItemStack order, ItemStack[] items, CreativeModeTab.TabVisibility visibility) {
            for (ItemStack item : items) {
                this.event.accept(item, visibility);
            }
        }

        @Override
        public void addBefore(ItemStack order, ItemStack[] items, CreativeModeTab.TabVisibility visibility) {
            for (ItemStack item : items) {
                this.event.accept(item, visibility);
            }
        }

        @Override
        public void remove(Ingredient filter, boolean removeDisplay, boolean removeSearch) {
            ArrayList<AbstractMap.SimpleEntry<ItemStack, CreativeModeTab.TabVisibility>> entries = new ArrayList<AbstractMap.SimpleEntry<ItemStack, CreativeModeTab.TabVisibility>>();
            for (Map.Entry entry : this.event.getEntries()) {
                if (!filter.test((ItemStack)entry.getKey())) continue;
                CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)entry.getValue();
                if (removeDisplay && removeSearch) {
                    visibility = null;
                }
                if (removeDisplay && visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    visibility = CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY;
                }
                if (removeSearch && visibility == CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS) {
                    visibility = CreativeModeTab.TabVisibility.PARENT_TAB_ONLY;
                }
                entries.add(new AbstractMap.SimpleEntry<ItemStack, CreativeModeTab.TabVisibility>((ItemStack)entry.getKey(), visibility));
            }
            for (Map.Entry entry : entries) {
                if (entry.getValue() == null) {
                    this.event.getEntries().remove((Object)((ItemStack)entry.getKey()));
                    continue;
                }
                this.event.getEntries().put((Object)((ItemStack)entry.getKey()), (Object)((CreativeModeTab.TabVisibility)entry.getValue()));
            }
        }
    }
}

