/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.player;

import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class AdvancementJS {
    public final AdvancementNode node;
    public final AdvancementHolder holder;
    public final Advancement advancement;

    public AdvancementJS(AdvancementNode node) {
        this.node = node;
        this.holder = node.holder();
        this.advancement = node.advancement();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof AdvancementJS)) return false;
        AdvancementJS a = (AdvancementJS)o;
        if (!this.node.equals((Object)a.node)) return false;
        return true;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String toString() {
        return this.getId().toString();
    }

    public ResourceLocation id() {
        return this.getId();
    }

    public ResourceLocation getId() {
        return this.node.holder().id();
    }

    @Nullable
    public AdvancementJS getParent() {
        AdvancementNode parent = this.node.parent();
        return parent == null ? null : new AdvancementJS(parent);
    }

    public Set<AdvancementJS> getChildren() {
        LinkedHashSet<AdvancementJS> set = new LinkedHashSet<AdvancementJS>();
        for (AdvancementNode a : this.node.children()) {
            set.add(new AdvancementJS(a));
        }
        return set;
    }

    public void addChild(AdvancementJS a) {
        this.node.addChild(a.node);
    }

    public Component getDisplayText() {
        return (Component)this.advancement.name().orElse(Component.empty());
    }

    public boolean hasDisplay() {
        return this.advancement.display().isPresent();
    }

    public Component getTitle() {
        return this.advancement.display().map(DisplayInfo::getTitle).orElse((Component)Component.empty());
    }

    public Component getDescription() {
        return this.advancement.display().map(DisplayInfo::getDescription).orElse((Component)Component.empty());
    }

    @Nullable
    public DisplayInfo getDisplay() {
        return this.advancement.display().orElse(null);
    }
}

