/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import dev.latvian.mods.kubejs.core.CraftingContainerKJS;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ModifyRecipeCraftingGrid {
    private final CraftingContainer container;

    public ModifyRecipeCraftingGrid(CraftingContainer c) {
        this.container = c;
    }

    public ItemStack get(int index) {
        return this.container.getItem(index).copy();
    }

    public List<ItemStack> findAll(Ingredient ingredient) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = this.container.getItem(i);
            if (!ingredient.test(stack)) continue;
            list.add(stack.copy());
        }
        return list;
    }

    public List<ItemStack> findAll() {
        return this.findAll(IngredientHelper.get().wildcard());
    }

    public ItemStack find(Ingredient ingredient, int skip) {
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = this.container.getItem(i);
            if (!ingredient.test(stack)) continue;
            if (skip > 0) {
                --skip;
                continue;
            }
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    public ItemStack find(Ingredient ingredient) {
        return this.find(ingredient, 0);
    }

    public int getWidth() {
        return this.container.getWidth();
    }

    public int getHeight() {
        return this.container.getHeight();
    }

    @Nullable
    public AbstractContainerMenu getMenu() {
        return ((CraftingContainerKJS)this.container).kjs$getMenu();
    }

    @Nullable
    public Player getPlayer() {
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (abstractContainerMenu instanceof CraftingMenu) {
            CraftingMenu menu = (CraftingMenu)abstractContainerMenu;
            if (menu.player != null) {
                return menu.player;
            }
        }
        if ((abstractContainerMenu = this.getMenu()) instanceof InventoryMenu) {
            InventoryMenu menu = (InventoryMenu)abstractContainerMenu;
            if (menu.owner != null) {
                return menu.owner;
            }
        }
        return null;
    }
}

