/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.ingredient;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.helpers.IngredientHelper;
import dev.latvian.mods.kubejs.recipe.ingredient.KubeJSIngredient;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.regex.Pattern;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RegExIngredient
extends KubeJSIngredient {
    public static final Codec<RegExIngredient> CODEC = ExtraCodecs.stringResolverCodec(UtilsJS::toRegexString, UtilsJS::parseRegex).fieldOf("pattern").codec().xmap(RegExIngredient::new, ingredient -> ingredient.pattern);
    public final Pattern pattern;

    public RegExIngredient(Pattern pattern) {
        super(IngredientHelper.REGEX);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern for a RegExIngredient cannot be null! Check your pattern format");
        }
        this.pattern = pattern;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && this.pattern.matcher(stack.kjs$getId()).find();
    }
}

