/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.ingredientaction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.hooks.item.ItemStackHooks;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ConsumeAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.mods.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.ReplaceAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientAction
extends IngredientActionFilter {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Map<String, Function<JsonObject, IngredientAction>> FACTORY_MAP = new HashMap<String, Function<JsonObject, IngredientAction>>();
    public static final Codec<IngredientAction> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> IngredientAction.fromJson((JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue()), action -> new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)action.toJson()));

    public static List<IngredientAction> parseList(JsonElement json) {
        if (json == null || !json.isJsonArray()) {
            return List.of();
        }
        ArrayList list = new ArrayList();
        for (JsonElement e : json.getAsJsonArray()) {
            IngredientAction.fromJson(e).result().ifPresent(list::add);
        }
        return list.isEmpty() ? List.of() : list;
    }

    private static DataResult<IngredientAction> fromJson(JsonElement json) {
        IngredientAction action;
        if (json.isJsonArray()) {
            return DataResult.error(() -> "Unexpected array, did you mean to use parseList?");
        }
        if (!json.isJsonObject()) {
            return DataResult.error(() -> "Expected object, got " + json);
        }
        JsonObject o = json.getAsJsonObject();
        String type = o.has("type") ? o.get("type").getAsString() : "";
        Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(type);
        IngredientAction ingredientAction = action = factory == null ? null : factory.apply(o);
        if (action != null) {
            action.filterIndex = GsonHelper.getAsInt((JsonObject)o, (String)"filter_index", (int)-1);
            action.filterIngredient = o.has("filter_ingredient") ? IngredientJS.of(o.get("filter_ingredient")) : null;
            return DataResult.success((Object)action);
        }
        return DataResult.error(() -> "Unknown ingredient action type: " + type);
    }

    public static List<IngredientAction> readList(FriendlyByteBuf buf) {
        int s = buf.readVarInt();
        if (s <= 0) {
            return List.of();
        }
        ArrayList<IngredientAction> list = new ArrayList<IngredientAction>();
        for (int i = 0; i < s; ++i) {
            IngredientAction action;
            Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(buf.readUtf());
            IngredientAction ingredientAction = action = factory == null ? null : factory.apply((JsonObject)GSON.fromJson(buf.readUtf(), JsonObject.class));
            if (action == null) continue;
            action.filterIndex = buf.readVarInt();
            String ij = buf.readUtf();
            action.filterIngredient = ij.isEmpty() ? null : IngredientJS.of(GSON.fromJson(ij, JsonObject.class));
            list.add(action);
        }
        return list.isEmpty() ? List.of() : list;
    }

    public static void writeList(FriendlyByteBuf buf, @Nullable List<IngredientAction> list) {
        if (list == null || list.isEmpty()) {
            buf.writeVarInt(0);
            return;
        }
        buf.writeVarInt(list.size());
        for (IngredientAction action : list) {
            buf.writeUtf(action.getType());
            JsonObject json = new JsonObject();
            action.toJson(json);
            buf.writeUtf(GSON.toJson((JsonElement)json));
            buf.writeVarInt(action.filterIndex);
            buf.writeUtf(action.filterIngredient == null ? "" : GSON.toJson(action.filterIngredient.toJsonJS()));
        }
    }

    public static ItemStack getRemaining(CraftingContainer container, int index, List<IngredientAction> ingredientActions) {
        ItemStack stack = container.getItem(index);
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (IngredientAction action : ingredientActions) {
            if (!action.checkFilter(index, stack)) continue;
            return action.transform(stack.copy(), index, container);
        }
        if (ItemStackHooks.hasCraftingRemainingItem((ItemStack)stack)) {
            return ItemStackHooks.getCraftingRemainingItem((ItemStack)stack);
        }
        return ItemStack.EMPTY;
    }

    public abstract ItemStack transform(ItemStack var1, int var2, CraftingContainer var3);

    public abstract String getType();

    public void toJson(JsonObject json) {
    }

    public final JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (this.filterIngredient != null) {
            json.add("filter_ingredient", this.filterIngredient.toJsonJS());
        }
        if (this.filterIndex != -1) {
            json.addProperty("filter_index", (Number)this.filterIndex);
        }
        this.toJson(json);
        return json;
    }

    static {
        FACTORY_MAP.put("custom", json -> new CustomIngredientAction(json.get("id").getAsString()));
        FACTORY_MAP.put("damage", json -> new DamageAction(json.get("damage").getAsInt()));
        FACTORY_MAP.put("replace", json -> new ReplaceAction(ItemStackJS.resultFromRecipeJson(json.get("item"))));
        FACTORY_MAP.put("keep", json -> new KeepAction());
        FACTORY_MAP.put("consume", json -> new ConsumeAction());
    }
}

